/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.guicey.gsp.app;

import com.google.common.base.Joiner;
import io.dropwizard.jetty.setup.ServletEnvironment;
import io.dropwizard.setup.Environment;
import java.nio.charset.StandardCharsets;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.servlet.DispatcherType;
import javax.servlet.Filter;
import javax.servlet.Servlet;
import org.glassfish.jersey.server.model.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.vyarus.guicey.gsp.app.AppReportBuilder;
import ru.vyarus.guicey.gsp.app.GlobalConfig;
import ru.vyarus.guicey.gsp.app.asset.LazyLocationProvider;
import ru.vyarus.guicey.gsp.app.asset.MultiSourceAssetServlet;
import ru.vyarus.guicey.gsp.app.filter.ServerPagesFilter;
import ru.vyarus.guicey.gsp.app.filter.redirect.ErrorRedirect;
import ru.vyarus.guicey.gsp.app.filter.redirect.SpaSupport;
import ru.vyarus.guicey.gsp.app.filter.redirect.TemplateRedirect;
import ru.vyarus.guicey.gsp.app.rest.DirectTemplateResource;
import ru.vyarus.guicey.gsp.app.rest.log.ResourcePath;
import ru.vyarus.guicey.gsp.app.util.PathUtils;

public class ServerPagesApp {
    public final Map<Integer, String> errorPages = new TreeMap<Integer, String>();
    public boolean mainContext;
    public String name;
    public String resourcePath;
    public String uriPath;
    public String fullUriPath;
    public String indexFile = "";
    public String fileRequestPattern = "(?:^|/)([^/]+\\.(?:[a-zA-Z\\d]+))(?:\\?.+)?$";
    public List<String> requiredRenderers;
    public boolean spaSupport;
    public String spaNoRedirectRegex = "\\.(html|css|js|png|jpg|jpeg|gif|ico|xml|rss|txt|eot|svg|ttf|woff|woff2|cur)(\\?((r|v|rel|rev)=[\\-\\.\\w]*)?)?$";
    protected TemplateRedirect templateRedirect;
    protected LazyLocationProvider locationsProvider;
    private boolean started;
    private final Logger logger = LoggerFactory.getLogger(ServerPagesApp.class);
    private final GlobalConfig globalConfig;

    public ServerPagesApp(GlobalConfig globalConfig) {
        this.globalConfig = globalConfig;
    }

    public void setup(Environment environment) {
        ServletEnvironment context = this.mainContext ? environment.servlets() : environment.admin();
        String contextMapping = this.mainContext ? environment.getApplicationContext().getContextPath() : environment.getAdminContext().getContextPath();
        this.fullUriPath = PathUtils.path(contextMapping, this.uriPath);
        this.locationsProvider = new LazyLocationProvider(this.resourcePath, this.name, this.globalConfig);
        this.installAssetsServlet(context, this.locationsProvider);
        SpaSupport spa = new SpaSupport(this.spaSupport, this.fullUriPath, this.uriPath, this.spaNoRedirectRegex);
        this.templateRedirect = new TemplateRedirect(environment.getJerseyServletContainer(), this.name, this.fullUriPath, this.locationsProvider, new ErrorRedirect(this.uriPath, this.errorPages, spa));
        this.installTemplatesSupportFilter(context, this.templateRedirect, spa);
        environment.jersey().getResourceConfig().registerResources(new Resource[]{Resource.builder(DirectTemplateResource.class).path("/" + this.name).extended(false).build()});
    }

    public void initialize(String restContext, String restMapping, Set<ResourcePath> paths) {
        this.templateRedirect.setRootPath(restContext, restMapping);
        this.locationsProvider.get();
        this.logger.info(AppReportBuilder.build(this, paths));
        this.started = true;
    }

    public boolean isStarted() {
        return this.started;
    }

    private void installAssetsServlet(ServletEnvironment context, LazyLocationProvider locationsProvider) {
        Set clash = context.addServlet(this.name, (Servlet)new MultiSourceAssetServlet(locationsProvider, this.uriPath, this.indexFile, StandardCharsets.UTF_8)).addMapping(new String[]{this.uriPath + '*'});
        if (clash != null && !clash.isEmpty()) {
            throw new IllegalStateException(String.format("Assets servlet %s registration clash with already installed servlets on paths: %s", this.name, Joiner.on((char)',').join((Iterable)clash)));
        }
    }

    private void installTemplatesSupportFilter(ServletEnvironment context, TemplateRedirect templateRedirect, SpaSupport spa) {
        EnumSet<DispatcherType> types = EnumSet.of(DispatcherType.REQUEST, DispatcherType.FORWARD);
        context.addFilter(this.name + "Templates", (Filter)new ServerPagesFilter(this.fullUriPath, this.fileRequestPattern, this.indexFile, templateRedirect, spa, this.globalConfig.getRenderers())).addMappingForServletNames(types, false, new String[]{this.name});
    }
}

