/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.guicey.gsp.app.asset;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.inject.Provider;
import ru.vyarus.guicey.gsp.app.GlobalConfig;
import ru.vyarus.guicey.gsp.app.util.PathUtils;

public class LazyLocationProvider
implements Provider<List<String>> {
    private final String primaryLocation;
    private final String app;
    private final GlobalConfig config;
    private List<String> locations;

    public LazyLocationProvider(String primaryLocation, String app, GlobalConfig config) {
        this.primaryLocation = this.convert(primaryLocation);
        this.app = app;
        this.config = config;
    }

    public List<String> get() {
        if (this.locations != null) {
            return this.locations;
        }
        ArrayList<String> locations = new ArrayList<String>();
        locations.add(this.primaryLocation);
        locations.addAll(this.config.getExtensions(this.app));
        Collections.reverse(locations);
        this.locations = locations.stream().map(this::convert).collect(Collectors.toList());
        return this.locations;
    }

    public String getPrimaryLocation() {
        return this.primaryLocation;
    }

    private String convert(String path) {
        return PathUtils.endSlash(PathUtils.trimSlashes(path));
    }
}

