/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.guicey.gsp.app.asset;

import io.dropwizard.servlets.assets.AssetServlet;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.List;
import javax.annotation.Nullable;
import ru.vyarus.guicey.gsp.app.asset.LazyLocationProvider;
import ru.vyarus.guicey.gsp.app.util.PathUtils;
import ru.vyarus.guicey.gsp.app.util.ResourceLookup;

public class MultiSourceAssetServlet
extends AssetServlet {
    private static final long serialVersionUID = 6393345594784987909L;
    private final transient LazyLocationProvider locationsProvider;

    public MultiSourceAssetServlet(LazyLocationProvider locationProvider, String uriPath, @Nullable String indexFile, @Nullable Charset defaultCharset) {
        super(locationProvider.getPrimaryLocation(), uriPath, indexFile, defaultCharset);
        this.locationsProvider = locationProvider;
    }

    protected URL getResourceUrl(String absoluteRequestedResourcePath) {
        Object locations;
        String realPath = absoluteRequestedResourcePath;
        if (!PathUtils.endSlash(realPath).equals(this.locationsProvider.getPrimaryLocation()) && (locations = this.locationsProvider.get()).size() > 1) {
            String path = absoluteRequestedResourcePath.substring(this.locationsProvider.getPrimaryLocation().length());
            realPath = ResourceLookup.lookup(path, (List<String>)locations);
        }
        return super.getResourceUrl(realPath);
    }
}

