/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.guicey.gsp.app.rest.support;

import java.io.IOException;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerResponseContext;
import javax.ws.rs.container.ContainerResponseFilter;
import javax.ws.rs.ext.Provider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.vyarus.guicey.gsp.app.filter.redirect.TemplateRedirect;
import ru.vyarus.guicey.gsp.app.rest.support.TemplateRestCodeError;
import ru.vyarus.guicey.gsp.views.template.Template;
import ru.vyarus.guicey.gsp.views.template.TemplateContext;

@Provider
@Template
public class TemplateErrorResponseFilter
implements ContainerResponseFilter {
    private final Logger logger = LoggerFactory.getLogger(TemplateErrorResponseFilter.class);

    public void filter(ContainerRequestContext requestContext, ContainerResponseContext responseContext) throws IOException {
        TemplateContext context;
        int status = responseContext.getStatus();
        if (status >= 400 && (context = TemplateRedirect.templateContext()) != null && !context.getResponse().isCommitted()) {
            this.logger.debug("Rest response code {} detected for template path {}", (Object)status, (Object)requestContext.getUriInfo().getPath());
            context.redirectError((Throwable)((Object)new TemplateRestCodeError(requestContext, status)));
        }
    }
}

