/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.guicey.gsp.app;

import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import ru.vyarus.dropwizard.guice.module.installer.util.Reporter;
import ru.vyarus.guicey.gsp.app.ServerPagesApp;
import ru.vyarus.guicey.gsp.app.rest.log.ResourcePath;
import ru.vyarus.guicey.gsp.app.util.PathUtils;
import ru.vyarus.guicey.gsp.views.template.ManualErrorHandling;

public final class AppReportBuilder {
    private AppReportBuilder() {
    }

    public static String build(ServerPagesApp app, Set<ResourcePath> paths) {
        StringBuilder res = new StringBuilder(String.format("Server pages app '%s' registered on uri '%s' in %s context", app.name, app.fullUriPath + '*', app.mainContext ? "main" : "admin"));
        AppReportBuilder.reportStaticResources(res, app);
        AppReportBuilder.reportRestPaths(res, app, paths);
        AppReportBuilder.reportErrorPages(res, app);
        AppReportBuilder.reportSpaSupport(res, app);
        return res.toString();
    }

    private static void reportStaticResources(StringBuilder res, ServerPagesApp app) {
        res.append(Reporter.NEWLINE).append(Reporter.NEWLINE).append("    ").append("Static resources locations:").append(Reporter.NEWLINE);
        Iterator iterator = app.locationsProvider.get().iterator();
        while (iterator.hasNext()) {
            String path = (String)iterator.next();
            res.append("    ").append("    ").append("/").append(path).append(Reporter.NEWLINE);
        }
        res.append(Reporter.NEWLINE);
    }

    private static void reportRestPaths(StringBuilder res, ServerPagesApp app, Set<ResourcePath> paths) {
        res.append("    ").append("Mapped handlers:").append(Reporter.NEWLINE);
        for (ResourcePath handle : paths) {
            Method handlingMethod = handle.getMethod().getInvocable().getHandlingMethod();
            boolean disabledErrors = handle.getKlass().isAnnotationPresent(ManualErrorHandling.class) || handlingMethod != null && handlingMethod.isAnnotationPresent(ManualErrorHandling.class);
            res.append("    ").append("    ").append(String.format("%-7s %s  (%s #%s)%s", handle.getMethod().getHttpMethod(), PathUtils.cleanUpPath(app.fullUriPath + handle.getUrl().substring(app.name.length() + 1)), handle.getKlass().getName(), handle.getMethod().getInvocable().getDefinitionMethod().getName(), disabledErrors ? " [DISABLED ERRORS]" : "")).append(Reporter.NEWLINE);
        }
    }

    private static void reportErrorPages(StringBuilder res, ServerPagesApp app) {
        Map<Integer, String> errorPages = app.errorPages;
        if (!errorPages.isEmpty()) {
            res.append(Reporter.NEWLINE).append("    ").append("Error pages:").append(Reporter.NEWLINE);
            int defKey = -1;
            for (Map.Entry<Integer, String> entry : errorPages.entrySet()) {
                if (entry.getKey() == -1) continue;
                AppReportBuilder.printErrorPage(res, entry.getKey().toString(), entry.getValue());
            }
            if (errorPages.containsKey(-1)) {
                AppReportBuilder.printErrorPage(res, "*", errorPages.get(-1));
            }
        }
    }

    private static void printErrorPage(StringBuilder res, String code, String page) {
        res.append("    ").append("    ").append(String.format("%-7s %s", code, PathUtils.prefixSlash(page))).append(Reporter.NEWLINE);
    }

    private static void reportSpaSupport(StringBuilder res, ServerPagesApp app) {
        if (app.spaSupport) {
            res.append(Reporter.NEWLINE).append("    ").append("SPA routing enabled");
            if (!app.spaNoRedirectRegex.equals("\\.(html|css|js|png|jpg|jpeg|gif|ico|xml|rss|txt|eot|svg|ttf|woff|woff2|cur)(\\?((r|v|rel|rev)=[\\-\\.\\w]*)?)?$")) {
                res.append(" (with custom pattern)");
            }
            res.append(Reporter.NEWLINE);
        }
    }
}

