/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.guicey.gsp.app;

import com.google.common.base.Preconditions;
import io.dropwizard.Configuration;
import io.dropwizard.ConfiguredBundle;
import io.dropwizard.setup.Bootstrap;
import io.dropwizard.setup.Environment;
import io.dropwizard.views.ViewRenderer;
import java.util.ArrayList;
import ru.vyarus.guicey.gsp.ServerPagesBundle;
import ru.vyarus.guicey.gsp.app.GlobalConfig;
import ru.vyarus.guicey.gsp.app.ServerPagesApp;

public class ServerPagesAppBundle
implements ConfiguredBundle<Configuration> {
    private static final String COMMA = ", ";
    private final GlobalConfig config;
    private final ServerPagesApp app;

    public ServerPagesAppBundle(GlobalConfig config, ServerPagesApp app) {
        this.config = config;
        this.app = app;
    }

    public void initialize(Bootstrap<?> bootstrap) {
        Preconditions.checkState((boolean)this.config.isViewsSupportRegistered(), (String)"Server pages support bundle was not installed: use %s.builder() to create bundle", (Object)ServerPagesBundle.class.getSimpleName());
    }

    public void run(Configuration configuration, Environment environment) throws Exception {
        this.validateRequirements();
        this.app.setup(environment);
    }

    private void validateRequirements() {
        if (this.app.requiredRenderers == null) {
            return;
        }
        ArrayList<String> available = new ArrayList<String>();
        ArrayList<String> required = new ArrayList<String>(this.app.requiredRenderers);
        for (ViewRenderer renderer : this.config.getRenderers()) {
            String key = renderer.getConfigurationKey();
            available.add(key);
            required.remove(key);
        }
        Preconditions.checkState((boolean)required.isEmpty(), (String)"Required template engines are missed for server pages application '%s': %s (available engines: %s)", (Object)this.app.name, (Object)String.join((CharSequence)COMMA, required), (Object)String.join((CharSequence)COMMA, available));
    }
}

