/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.guicey.gsp.views.template;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.List;
import javax.annotation.Nullable;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.WebApplicationException;
import org.glassfish.jersey.server.internal.process.MappableException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.vyarus.guicey.gsp.app.filter.redirect.ErrorRedirect;
import ru.vyarus.guicey.gsp.app.filter.redirect.TemplateRedirect;
import ru.vyarus.guicey.gsp.app.util.PathUtils;
import ru.vyarus.guicey.gsp.app.util.ResourceLookup;

public class TemplateContext {
    private final Logger logger = LoggerFactory.getLogger(TemplateContext.class);
    private final String appName;
    private final String rootUrl;
    private final List<String> resourcePaths;
    private final ErrorRedirect errorRedirect;
    private final HttpServletRequest request;
    private final HttpServletResponse response;
    private Class resourceClass;
    private String annotationTemplate;
    private boolean manualErrorHandling;

    public TemplateContext(String appName, String rootUrl, List<String> resourcePaths, ErrorRedirect errorRedirect, HttpServletRequest request, HttpServletResponse response) {
        this.appName = appName;
        this.rootUrl = rootUrl;
        this.resourcePaths = resourcePaths;
        this.errorRedirect = errorRedirect;
        this.request = request;
        this.response = response;
    }

    public static TemplateContext getInstance() {
        return (TemplateContext)Preconditions.checkNotNull((Object)TemplateRedirect.templateContext(), (Object)"No template context found for current thread");
    }

    public String getAppName() {
        return this.appName;
    }

    public String getRootUrl() {
        return this.rootUrl;
    }

    public String getUrl() {
        return this.getRequest().getRequestURI();
    }

    public HttpServletRequest getRequest() {
        return this.request;
    }

    public HttpServletResponse getResponse() {
        return this.response;
    }

    public void setResourceClass(Class base) {
        this.resourceClass = base;
    }

    public void setAnnotationTemplate(String template) {
        this.annotationTemplate = template;
    }

    public void setManualErrorHandling(boolean manualErrors) {
        this.manualErrorHandling = manualErrors;
    }

    @SuppressFBWarnings(value={"NP_PARAMETER_MUST_BE_NONNULL_BUT_MARKED_AS_NULLABLE"})
    public String lookupTemplatePath(@Nullable String template) {
        String resourceBaseLocation;
        String path = Strings.emptyToNull((String)template);
        if (path == null) {
            path = this.annotationTemplate;
        }
        Preconditions.checkNotNull((Object)path, (Object)"Template name not specified neither directly in model nor in @Template annotation");
        if (!path.startsWith("/") && this.resourceClass != null && (resourceBaseLocation = ResourceLookup.lookup(this.resourceClass, path)) != null) {
            path = PathUtils.prefixSlash(resourceBaseLocation);
            this.logger.debug("Relative template '{}' found relative to {} class: '{}'", new Object[]{template, this.resourceClass.getSimpleName(), path});
        }
        if (!path.startsWith("/")) {
            path = PathUtils.prefixSlash(ResourceLookup.lookupOrFail(path, this.resourcePaths));
            this.logger.debug("Relative template '{}' resolved to '{}'", (Object)template, (Object)path);
        }
        ResourceLookup.existsOrFail(path);
        return path;
    }

    public boolean redirectError(Throwable ex) {
        return !this.manualErrorHandling && this.errorRedirect.redirect(this.getRequest(), this.getResponse(), this.wrap(ex));
    }

    private WebApplicationException wrap(Throwable exception) {
        Throwable cause = exception;
        while (cause instanceof MappableException) {
            cause = cause.getCause();
        }
        return cause instanceof WebApplicationException ? (WebApplicationException)cause : new WebApplicationException(cause, 500);
    }
}

