/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.guicey.gsp;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.dropwizard.Configuration;
import io.dropwizard.ConfiguredBundle;
import io.dropwizard.setup.Environment;
import io.dropwizard.views.ViewConfigurable;
import io.dropwizard.views.ViewRenderer;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.vyarus.dropwizard.guice.module.context.unique.item.UniqueGuiceyBundle;
import ru.vyarus.dropwizard.guice.module.installer.bundle.GuiceyBootstrap;
import ru.vyarus.dropwizard.guice.module.installer.bundle.GuiceyEnvironment;
import ru.vyarus.dropwizard.guice.module.installer.util.Reporter;
import ru.vyarus.guicey.gsp.app.GlobalConfig;
import ru.vyarus.guicey.gsp.app.ServerPagesApp;
import ru.vyarus.guicey.gsp.app.ServerPagesAppBundle;
import ru.vyarus.guicey.gsp.app.ServerPagesAppExtensionBundle;
import ru.vyarus.guicey.gsp.app.rest.log.ResourcePath;
import ru.vyarus.guicey.gsp.app.rest.log.RestPathsAnalyzer;
import ru.vyarus.guicey.gsp.app.rest.support.TemplateAnnotationFilter;
import ru.vyarus.guicey.gsp.app.rest.support.TemplateErrorResponseFilter;
import ru.vyarus.guicey.gsp.app.rest.support.TemplateExceptionListener;
import ru.vyarus.guicey.gsp.app.util.PathUtils;
import ru.vyarus.guicey.gsp.views.ConfiguredViewBundle;
import ru.vyarus.guicey.gsp.views.ViewRendererConfigurationModifier;

public class ServerPagesBundle
extends UniqueGuiceyBundle {
    public static final String FILE_REQUEST_PATTERN = "(?:^|/)([^/]+\\.(?:[a-zA-Z\\d]+))(?:\\?.+)?$";
    private static final Logger LOGGER = LoggerFactory.getLogger(ServerPagesBundle.class);
    private final GlobalConfig config;

    public ServerPagesBundle(GlobalConfig config) {
        this.config = config;
    }

    public static ViewsBuilder builder() {
        return new ViewsBuilder();
    }

    public static AppBuilder app(String name, String resourcePath, String uriPath) {
        LOGGER.debug("Registering server pages application {} on path {} with resources in {}", new Object[]{name, uriPath, resourcePath});
        return new AppBuilder(true, name, resourcePath, uriPath);
    }

    public static AppBuilder adminApp(String name, String resourcePath, String uriPath) {
        LOGGER.debug("Registering admin server pages application {} on path {} with resources in {}", new Object[]{name, uriPath, resourcePath});
        return new AppBuilder(false, name, resourcePath, uriPath);
    }

    public static ServerPagesAppExtensionBundle extendApp(String name, String resourcePath) {
        LOGGER.debug("Registering {} server pages application resources extension: {}", (Object)name, (Object)resourcePath);
        return new ServerPagesAppExtensionBundle(name, resourcePath);
    }

    public List<ViewRenderer> getRenderers() {
        return ImmutableList.copyOf(this.config.getRenderers());
    }

    public Map<String, Map<String, String>> getViewsConfig() {
        return ImmutableMap.copyOf((Map)((Map)Preconditions.checkNotNull(this.config.getViewsConfig(), (Object)"Views configuration is not created yet")));
    }

    public void initialize(GuiceyBootstrap bootstrap) {
        this.loadRenderers();
        bootstrap.shareState(ServerPagesBundle.class, (Object)this.config).dropwizardBundles(new ConfiguredBundle[]{new ConfiguredViewBundle(this.config)}).extensions(new Class[]{TemplateAnnotationFilter.class, TemplateErrorResponseFilter.class, TemplateExceptionListener.class});
    }

    public void run(GuiceyEnvironment environment) {
        environment.listen(it -> {
            Environment env = environment.environment();
            String contextPath = env.getJerseyServletContainer().getServletConfig().getServletContext().getContextPath();
            String restMapping = PathUtils.endSlash(PathUtils.trimStars(env.jersey().getUrlPattern()));
            RestPathsAnalyzer analyzer = RestPathsAnalyzer.build(env.jersey().getResourceConfig());
            for (ServerPagesApp app : this.config.getApps()) {
                Set<ResourcePath> paths = analyzer.select(app.name);
                app.initialize(contextPath, restMapping, paths);
            }
        });
    }

    private void loadRenderers() {
        ServiceLoader<ViewRenderer> renderers = ServiceLoader.load(ViewRenderer.class);
        renderers.forEach(xva$0 -> this.config.addRenderers((ViewRenderer)xva$0));
        Preconditions.checkState((!this.config.getRenderers().isEmpty() ? 1 : 0) != 0, (Object)"No template engines found (dropwizard views renderer)");
        StringBuilder res = new StringBuilder("Available dropwizard-views renderers:").append(Reporter.NEWLINE).append(Reporter.NEWLINE);
        for (ViewRenderer renderer : this.config.getRenderers()) {
            res.append("    ").append(String.format("%-15s (%s)", renderer.getConfigurationKey(), renderer.getClass().getName())).append(Reporter.NEWLINE);
        }
        LOGGER.info(res.toString());
    }

    public static class AppBuilder {
        private final ServerPagesApp app = new ServerPagesApp();

        protected AppBuilder(boolean mainContext, String name, String path, String uri) {
            this.app.mainContext = mainContext;
            this.app.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Name is required");
            this.app.uriPath = uri.endsWith("/") ? uri : uri + "/";
            Preconditions.checkArgument((boolean)path.startsWith("/"), (String)"%s is not an absolute path", (Object)path);
            Preconditions.checkArgument((!"/".equals(path) ? 1 : 0) != 0, (String)"%s is the classpath root", (Object)path);
            this.app.resourcePath = path.endsWith("/") ? path : path + "/";
        }

        public AppBuilder requireRenderers(String ... names) {
            this.app.requiredRenderers = Arrays.asList(names);
            return this;
        }

        public AppBuilder spaRouting() {
            return this.spaRouting(null);
        }

        public AppBuilder spaRouting(String noRedirectRegex) {
            if (noRedirectRegex != null) {
                this.app.spaNoRedirectRegex = noRedirectRegex;
            }
            this.app.spaSupport = true;
            return this;
        }

        public AppBuilder indexPage(String name) {
            this.app.indexFile = name;
            return this;
        }

        public AppBuilder errorPage(String path) {
            return this.errorPage(-1, path);
        }

        public AppBuilder errorPage(int code, String path) {
            Preconditions.checkArgument((code >= 400 || code == -1 ? 1 : 0) != 0, (Object)"Only error codes (4xx, 5xx) allowed for mapping");
            this.app.errorPages.put(code, path);
            return this;
        }

        public AppBuilder attachPaths(String ... paths) {
            this.app.extendedResourceLocations.addAll(Arrays.asList(paths));
            return this;
        }

        public AppBuilder attachWebjars() {
            return this.attachPaths("META-INF/resources/webjars/");
        }

        public AppBuilder filePattern(String regex) {
            this.app.fileRequestPattern = (String)Preconditions.checkNotNull((Object)regex, (Object)"Regex can't be null");
            return this;
        }

        public AppBuilder viewsConfigurationModifier(String name, ViewRendererConfigurationModifier modifier) {
            LOGGER.info("Server pages application '{}' modifies '{}' section of views configuration", (Object)this.app.name, (Object)name);
            this.app.viewsConfigModifiers.put(name, modifier);
            return this;
        }

        public ServerPagesAppBundle build() {
            return new ServerPagesAppBundle(this.app);
        }
    }

    public static class ViewsBuilder {
        private final GlobalConfig config = new GlobalConfig();

        public ViewsBuilder addViewRenderers(ViewRenderer ... renderers) {
            this.config.addRenderers(renderers);
            return this;
        }

        public <T extends Configuration> ViewsBuilder viewsConfiguration(ViewConfigurable<T> configurable) {
            this.config.setConfigurable(configurable);
            return this;
        }

        public ViewsBuilder viewsConfigurationModifier(String name, ViewRendererConfigurationModifier modifier) {
            this.config.addConfigModifier(name, modifier);
            return this;
        }

        public ViewsBuilder printViewsConfiguration() {
            this.config.printConfiguration();
            return this;
        }

        public ServerPagesBundle build() {
            return new ServerPagesBundle(this.config);
        }
    }
}

