/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.guicey.gsp.app.asset;

import io.dropwizard.servlets.assets.AssetServlet;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.List;
import javax.annotation.Nullable;
import ru.vyarus.guicey.gsp.app.util.PathUtils;
import ru.vyarus.guicey.gsp.app.util.ResourceLookup;

public class MultiSourceAssetServlet
extends AssetServlet {
    private static final long serialVersionUID = 6393345594784987909L;
    private final List<String> resourceLocations;

    public MultiSourceAssetServlet(List<String> resourceLocations, String uriPath, @Nullable String indexFile, @Nullable Charset defaultCharset) {
        super(resourceLocations.get(resourceLocations.size() - 1), uriPath, indexFile, defaultCharset);
        this.resourceLocations = resourceLocations;
    }

    protected URL getResourceUrl(String absoluteRequestedResourcePath) {
        String realPath = absoluteRequestedResourcePath;
        String primaryLocation = this.resourceLocations.get(this.resourceLocations.size() - 1);
        if (!PathUtils.endSlash(realPath).equals(primaryLocation) && this.resourceLocations.size() > 1) {
            String path = absoluteRequestedResourcePath.substring(primaryLocation.length());
            realPath = ResourceLookup.lookup(path, this.resourceLocations);
        }
        return super.getResourceUrl(realPath);
    }
}

