/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.guicey.gsp.app.filter;

import com.google.common.base.Preconditions;
import io.dropwizard.views.View;
import io.dropwizard.views.ViewRenderer;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.vyarus.guicey.gsp.app.filter.AssetError;
import ru.vyarus.guicey.gsp.app.filter.redirect.SpaSupport;
import ru.vyarus.guicey.gsp.app.filter.redirect.TemplateRedirect;
import ru.vyarus.guicey.gsp.app.util.PathUtils;
import ru.vyarus.guicey.spa.filter.ResponseWrapper;

public class ServerPagesFilter
implements Filter {
    private final Logger logger = LoggerFactory.getLogger(ServerPagesFilter.class);
    private final String uriPath;
    private final Pattern filePattern;
    private final String index;
    private final TemplateRedirect redirect;
    private final SpaSupport spa;
    private final Iterable<ViewRenderer> renderers;

    public ServerPagesFilter(String uriPath, String filePattern, String index, TemplateRedirect redirect, SpaSupport spa, Iterable<ViewRenderer> renderers) {
        this.uriPath = uriPath;
        this.filePattern = Pattern.compile(filePattern);
        this.index = index;
        this.redirect = redirect;
        this.spa = spa;
        this.renderers = renderers;
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest req = (HttpServletRequest)servletRequest;
        HttpServletResponse resp = (HttpServletResponse)servletResponse;
        this.logger.debug("Processing request {}", (Object)req.getRequestURI());
        this.spa.markPossibleSpaRoute(req, resp);
        String pathFile = this.findFileInPath(req);
        if (pathFile != null && !this.isTemplate(pathFile)) {
            this.logger.debug("Serving asset: {}", (Object)req.getRequestURI());
            this.serveAsset(req, resp, chain);
            return;
        }
        String page = req.getRequestURI().substring(this.uriPath.length());
        if (page.isEmpty()) {
            page = this.index;
        }
        this.redirect.redirect(req, resp, page);
    }

    public void destroy() {
    }

    private String findFileInPath(HttpServletRequest req) {
        if (this.isRoot(req)) {
            return this.filePattern.matcher(this.index).find() ? this.index : null;
        }
        Matcher matcher = this.filePattern.matcher(req.getRequestURI());
        boolean detected = matcher.find();
        Preconditions.checkState((!detected || matcher.groupCount() > 0 ? 1 : 0) != 0, (String)"File detection pattern %s did not contain file capture group (1)", (Object)this.filePattern.pattern());
        return detected ? matcher.group(1) : null;
    }

    private boolean isRoot(HttpServletRequest req) {
        String uri = req.getRequestURI();
        String path = PathUtils.endSlash(uri);
        return path.equals(this.uriPath);
    }

    private boolean isTemplate(String file) {
        DummyView view = new DummyView(file);
        for (ViewRenderer renderer : this.renderers) {
            if (!renderer.isRenderable((View)view)) continue;
            this.logger.debug("Direct {} template {} request detected", (Object)renderer.getConfigurationKey(), (Object)file);
            return true;
        }
        return false;
    }

    private void serveAsset(HttpServletRequest req, HttpServletResponse resp, FilterChain chain) throws IOException, ServletException {
        ResponseWrapper wrapper = new ResponseWrapper(resp);
        chain.doFilter((ServletRequest)req, (ServletResponse)wrapper);
        this.handleError(req, resp, wrapper.getError());
    }

    private void handleError(HttpServletRequest req, HttpServletResponse resp, int error) throws IOException {
        if (error != 0) {
            this.logger.debug("Possible asset {} error detected: {}", (Object)req.getRequestURI(), (Object)error);
            if (error <= 400 || !this.redirect.getErrorRedirect().redirect(req, resp, new AssetError(req, error))) {
                this.logger.debug("Sending direct response code {} for asset {}", (Object)error, (Object)req.getRequestURI());
                resp.sendError(error);
            }
        }
    }

    private static class DummyView
    extends View {
        DummyView(String templateName) {
            super(templateName);
        }
    }
}

