/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.guicey.gsp.app.rest;

import io.dropwizard.views.View;
import javax.ws.rs.GET;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.vyarus.guicey.gsp.app.filter.redirect.ErrorRedirect;
import ru.vyarus.guicey.gsp.views.template.ErrorTemplateView;
import ru.vyarus.guicey.gsp.views.template.Template;
import ru.vyarus.guicey.gsp.views.template.TemplateContext;
import ru.vyarus.guicey.gsp.views.template.TemplateNotFoundException;
import ru.vyarus.guicey.gsp.views.template.TemplateView;

@Template
public class DirectTemplateResource {
    private final Logger logger = LoggerFactory.getLogger(DirectTemplateResource.class);

    @GET
    @Path(value="/{file:.*}")
    public View get(@PathParam(value="file") String file) {
        return this.handle(file);
    }

    @POST
    @Path(value="/{file:.*}")
    public View post(@PathParam(value="file") String file) {
        return this.handle(file);
    }

    private View handle(String path) {
        this.logger.debug("Direct template rendering: {}", (Object)path);
        try {
            TemplateContext.getInstance().setResourceClass(null);
            return ErrorRedirect.hasContextError() ? new ErrorTemplateView(path) : new TemplateView(path);
        }
        catch (TemplateNotFoundException ex) {
            throw new NotFoundException("Template " + path + " not found", (Throwable)ex);
        }
    }
}

