/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.guicey.gsp.app.rest.support;

import com.google.common.base.Throwables;
import javax.inject.Singleton;
import javax.ws.rs.ext.Provider;
import org.glassfish.jersey.server.monitoring.ApplicationEvent;
import org.glassfish.jersey.server.monitoring.ApplicationEventListener;
import org.glassfish.jersey.server.monitoring.RequestEvent;
import org.glassfish.jersey.server.monitoring.RequestEventListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.vyarus.guicey.gsp.app.filter.redirect.TemplateRedirect;
import ru.vyarus.guicey.gsp.views.template.TemplateContext;

@Provider
@Singleton
public class TemplateExceptionListener
implements ApplicationEventListener {
    private final RequestListener listener = new RequestListener();

    public void onEvent(ApplicationEvent event) {
    }

    public RequestEventListener onRequest(RequestEvent requestEvent) {
        return TemplateRedirect.templateContext() != null ? this.listener : null;
    }

    private static class RequestListener
    implements RequestEventListener {
        private final Logger logger = LoggerFactory.getLogger(TemplateExceptionListener.class);

        private RequestListener() {
        }

        public void onEvent(RequestEvent event) {
            if (event.getType() == RequestEvent.Type.ON_EXCEPTION) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Rest processing exception detected for path {}:\n{}", (Object)event.getUriInfo().getPath(), (Object)Throwables.getRootCause((Throwable)event.getException()).toString());
                }
                TemplateContext.getInstance().redirectError(event.getException());
            }
        }
    }
}

