/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.guicey.gsp.app.util;

import com.google.common.base.CharMatcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public final class PathUtils {
    public static final String SLASH = "/";
    private static final Pattern PATH_DIRTY_SLASHES = Pattern.compile("\\s*/\\s*/+\\s*");
    private static final CharMatcher TRIM_SLASH = CharMatcher.is((char)'/');
    private static final CharMatcher TRIM_STAR = CharMatcher.is((char)'*');

    private PathUtils() {
    }

    public static String normalizePath(String basePath, String path) {
        if (path == null || path.isEmpty()) {
            return basePath;
        }
        return PathUtils.path(basePath, path);
    }

    public static String path(String ... parts) {
        return PathUtils.cleanUpPath(StringUtils.join((Object[])parts, (String)SLASH));
    }

    public static String cleanUpPath(String path) {
        return PATH_DIRTY_SLASHES.matcher(path).replaceAll(SLASH).trim();
    }

    public static String prefixSlash(String path) {
        return path.startsWith(SLASH) ? path : SLASH + path;
    }

    public static String endSlash(String path) {
        if (path.isEmpty()) {
            return path;
        }
        return path.endsWith(SLASH) ? path : path + SLASH;
    }

    public static String trimStars(String path) {
        return TRIM_STAR.trimFrom((CharSequence)path);
    }

    public static String trimSlashes(String path) {
        return TRIM_SLASH.trimFrom((CharSequence)path);
    }

    public static String getPath(Class cls) {
        return cls.getPackage().getName().replace(".", SLASH);
    }
}

