/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.guicey.gsp.app.util;

import com.google.common.base.CharMatcher;
import com.google.common.base.MoreObjects;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.vyarus.guicey.gsp.app.util.PathUtils;
import ru.vyarus.guicey.gsp.views.template.TemplateNotFoundException;

public final class ResourceLookup {
    private static final Logger LOGGER = LoggerFactory.getLogger(ResourceLookup.class);

    private ResourceLookup() {
    }

    public static String lookup(Class base, String path) {
        String resourceBaseLocation = PathUtils.path(PathUtils.getPath(base), CharMatcher.is((char)'/').trimLeadingFrom((CharSequence)path));
        return ResourceLookup.exists(resourceBaseLocation) ? resourceBaseLocation : null;
    }

    public static String lookup(String path, List<String> rootPaths) {
        String templatePath = CharMatcher.is((char)'/').trimLeadingFrom((CharSequence)path);
        Iterator<String> it = rootPaths.iterator();
        String res = null;
        while (res == null && it.hasNext()) {
            String location = it.next();
            if (!ResourceLookup.exists(location + templatePath)) continue;
            res = location + templatePath;
        }
        return res;
    }

    public static String lookupOrFail(String path, List<String> rootPaths) throws TemplateNotFoundException {
        String lookup = ResourceLookup.lookup(path, rootPaths);
        if (lookup == null) {
            String err = String.format("Template %s not found in locations: %s", path, rootPaths);
            LOGGER.info(err);
            throw new TemplateNotFoundException(err);
        }
        return lookup;
    }

    public static boolean exists(String path) {
        ClassLoader loader = (ClassLoader)MoreObjects.firstNonNull((Object)Thread.currentThread().getContextClassLoader(), (Object)ResourceLookup.class.getClassLoader());
        return loader.getResource(CharMatcher.is((char)'/').trimLeadingFrom((CharSequence)path)) != null;
    }

    public static void existsOrFail(String path) throws TemplateNotFoundException {
        if (!ResourceLookup.exists(path)) {
            String err = String.format("Template not found on path %s", path);
            LOGGER.info(err);
            throw new TemplateNotFoundException(err);
        }
    }
}

