/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.guicey.gsp.app;

import com.google.common.base.Preconditions;
import io.dropwizard.views.ViewRenderer;
import java.util.ArrayList;
import ru.vyarus.dropwizard.guice.module.installer.bundle.GuiceyBootstrap;
import ru.vyarus.dropwizard.guice.module.installer.bundle.GuiceyBundle;
import ru.vyarus.dropwizard.guice.module.installer.bundle.GuiceyEnvironment;
import ru.vyarus.guicey.gsp.ServerPagesBundle;
import ru.vyarus.guicey.gsp.app.GlobalConfig;
import ru.vyarus.guicey.gsp.app.ServerPagesApp;

public class ServerPagesAppBundle
implements GuiceyBundle {
    private static final String COMMA = ", ";
    private final ServerPagesApp app;
    private GlobalConfig config;

    public ServerPagesAppBundle(ServerPagesApp app) {
        this.app = app;
    }

    public void initialize(GuiceyBootstrap bootstrap) {
        this.config = (GlobalConfig)bootstrap.sharedStateOrFail(ServerPagesBundle.class, "Either server pages support bundle was not installed (use %s.builder() to create bundle)  or it was installed after '%s' application bundle", new Object[]{ServerPagesBundle.class.getSimpleName(), this.app.name});
        this.config.register(this.app);
    }

    public void run(GuiceyEnvironment environment) {
        this.validateRequirements();
        this.app.setup(environment.environment(), this.config);
    }

    private void validateRequirements() {
        if (this.app.requiredRenderers == null) {
            return;
        }
        ArrayList<String> available = new ArrayList<String>();
        ArrayList<String> required = new ArrayList<String>(this.app.requiredRenderers);
        for (ViewRenderer renderer : this.config.getRenderers()) {
            String key = renderer.getConfigurationKey();
            available.add(key);
            required.remove(key);
        }
        Preconditions.checkState((boolean)required.isEmpty(), (String)"Required template engines are missed for server pages application '%s': %s (available engines: %s)", (Object)this.app.name, (Object)String.join((CharSequence)COMMA, required), (Object)String.join((CharSequence)COMMA, available));
    }
}

