/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.guicey.gsp.app;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import ru.vyarus.dropwizard.guice.debug.util.RenderUtils;
import ru.vyarus.dropwizard.guice.module.installer.util.PathUtils;
import ru.vyarus.dropwizard.guice.module.installer.util.Reporter;
import ru.vyarus.guicey.gsp.app.ServerPagesApp;
import ru.vyarus.guicey.gsp.app.rest.log.HiddenViewPath;
import ru.vyarus.guicey.gsp.app.rest.log.MappedViewPath;
import ru.vyarus.guicey.gsp.app.rest.log.ViewPath;
import ru.vyarus.guicey.gsp.views.template.ManualErrorHandling;

public final class AppReportBuilder {
    private static final String STAR = "*";

    private AppReportBuilder() {
    }

    public static String build(ServerPagesApp app) {
        StringBuilder res = new StringBuilder(String.format("Server pages app '%s' registered on uri '%s' in %s context", app.name, app.fullUriPath + '*', app.mainContext ? "main" : "admin"));
        AppReportBuilder.reportStaticResources(res, app);
        if (!app.viewPaths.isEmpty()) {
            Map<String, String> idx = AppReportBuilder.reportViewMappings(res, app);
            AppReportBuilder.reportRestPaths(res, app, idx);
        }
        AppReportBuilder.reportErrorPages(res, app);
        AppReportBuilder.reportSpaSupport(res, app);
        return res.toString();
    }

    private static void reportStaticResources(StringBuilder res, ServerPagesApp app) {
        res.append(Reporter.NEWLINE).append(Reporter.NEWLINE).append("    ").append("Static resources locations:").append(Reporter.NEWLINE);
        for (String url : app.assets.getLocations().keySet()) {
            res.append("    ").append("    ").append(PathUtils.normalize((String)(app.fullUriPath + PathUtils.leadingSlash((String)url)))).append(Reporter.NEWLINE);
            for (String path : app.assets.getLocations().get((Object)url)) {
                res.append("    ").append("    ").append("    ").append(PathUtils.trimSlashes((String)path).replace('/', '.')).append(Reporter.NEWLINE);
            }
            res.append(Reporter.NEWLINE);
        }
    }

    private static Map<String, String> reportViewMappings(StringBuilder res, ServerPagesApp app) {
        HashMap<String, String> idx = new HashMap<String, String>();
        int i = 1;
        res.append("    ").append("View rest mappings:").append(Reporter.NEWLINE);
        for (Map.Entry<String, String> entry : app.views.getPrefixes().entrySet()) {
            String url = entry.getKey();
            String marker = app.views.getPrefixes().size() == 1 ? "" : "[" + i++ + "]";
            idx.put(url, marker);
            res.append("    ").append("    ").append(String.format("%3s %-20s %s*", marker, PathUtils.path((String[])new String[]{app.fullUriPath, url}) + STAR, PathUtils.leadingSlash((String)PathUtils.path((String[])new String[]{app.templateRedirect.getRootPath(), entry.getValue()})))).append(Reporter.NEWLINE);
        }
        res.append(Reporter.NEWLINE);
        return idx;
    }

    private static void reportRestPaths(StringBuilder res, ServerPagesApp app, Map<String, String> idx) {
        ViewPath handle;
        res.append("    ").append("Mapped handlers:").append(Reporter.NEWLINE);
        for (MappedViewPath mappedViewPath : app.viewPaths) {
            handle = mappedViewPath.getPath();
            Method handlingMethod = handle.getMethod().getInvocable().getHandlingMethod();
            boolean disabledErrors = handle.getResourceType().isAnnotationPresent(ManualErrorHandling.class) || handlingMethod != null && handlingMethod.isAnnotationPresent(ManualErrorHandling.class);
            res.append("    ").append("    ").append(String.format("%-7s %s  (%s #%s)%s   %s", handle.getMethod().getHttpMethod(), PathUtils.path((String[])new String[]{app.fullUriPath, mappedViewPath.getMappedUrl()}), handle.getResourceType().getName(), handle.getMethod().getInvocable().getDefinitionMethod().getName(), disabledErrors ? " [DISABLED ERRORS]" : "", idx.get(mappedViewPath.getMapping()))).append(Reporter.NEWLINE);
        }
        if (!app.hiddenViewPaths.isEmpty()) {
            res.append(Reporter.NEWLINE).append("    ").append("(!) Unreachable handlers:").append(Reporter.NEWLINE);
            for (HiddenViewPath hiddenViewPath : app.hiddenViewPaths) {
                handle = hiddenViewPath.getPath();
                res.append("    ").append("    ").append(String.format("%-7s %s (%s #%s) of %s hidden by %s ", handle.getMethod().getHttpMethod(), PathUtils.path((String[])new String[]{app.fullUriPath, hiddenViewPath.getMappedUrl()}), RenderUtils.getClassName(handle.getResourceType()), handle.getMethod().getInvocable().getDefinitionMethod().getName(), idx.get(hiddenViewPath.getMapping()), idx.get(hiddenViewPath.getOverridingMapping()))).append(Reporter.NEWLINE);
            }
        }
    }

    private static void reportErrorPages(StringBuilder res, ServerPagesApp app) {
        Map<Integer, String> errorPages = app.errorPages;
        if (!errorPages.isEmpty()) {
            res.append(Reporter.NEWLINE).append("    ").append("Error pages:").append(Reporter.NEWLINE);
            int defKey = -1;
            for (Map.Entry<Integer, String> entry : errorPages.entrySet()) {
                if (entry.getKey() == -1) continue;
                AppReportBuilder.printErrorPage(res, entry.getKey().toString(), PathUtils.path((String[])new String[]{app.fullUriPath, entry.getValue()}));
            }
            if (errorPages.containsKey(-1)) {
                AppReportBuilder.printErrorPage(res, STAR, PathUtils.path((String[])new String[]{app.fullUriPath, errorPages.get(-1)}));
            }
        }
    }

    private static void printErrorPage(StringBuilder res, String code, String page) {
        res.append("    ").append("    ").append(String.format("%-7s %s", code, PathUtils.leadingSlash((String)page))).append(Reporter.NEWLINE);
    }

    private static void reportSpaSupport(StringBuilder res, ServerPagesApp app) {
        if (app.spaSupport) {
            res.append(Reporter.NEWLINE).append("    ").append("SPA routing enabled");
            if (!app.spaNoRedirectRegex.equals("\\.(html|css|js|png|jpg|jpeg|gif|ico|xml|rss|txt|eot|svg|ttf|woff|woff2|cur)(\\?((r|v|rel|rev)=[\\-\\.\\w]*)?)?$")) {
                res.append(" (with custom pattern)");
            }
            res.append(Reporter.NEWLINE);
        }
    }
}

