/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.guicey.gsp.app;

import com.google.common.base.Preconditions;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import io.dropwizard.Configuration;
import io.dropwizard.views.ViewConfigurable;
import io.dropwizard.views.ViewRenderer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import ru.vyarus.guicey.gsp.app.ServerPagesApp;
import ru.vyarus.guicey.gsp.app.asset.AssetSources;
import ru.vyarus.guicey.gsp.app.rest.mapping.ViewRestSources;
import ru.vyarus.guicey.gsp.views.ViewRendererConfigurationModifier;

public class GlobalConfig {
    private final List<String> names = new ArrayList<String>();
    private final List<ServerPagesApp> apps = new ArrayList<ServerPagesApp>();
    private final List<ViewRenderer> renderers = new ArrayList<ViewRenderer>();
    private final Multimap<String, ViewRendererConfigurationModifier> configModifiers = LinkedHashMultimap.create();
    private final Map<String, AssetSources> assetExtensions = new HashMap<String, AssetSources>();
    private final Map<String, ViewRestSources> restExtensions = new HashMap<String, ViewRestSources>();
    private ViewConfigurable<Configuration> configurable;
    private boolean printConfig;
    private Map<String, Map<String, String>> viewsConfig;
    private boolean locked;

    public void register(ServerPagesApp app) {
        Preconditions.checkArgument((!this.names.contains(app.name) ? 1 : 0) != 0, (String)"Server pages application with name '%s' is already registered", (Object)app.name);
        this.names.add(app.name);
        this.apps.add(app);
        for (Map.Entry<String, ViewRendererConfigurationModifier> entry : app.viewsConfigModifiers.entrySet()) {
            this.addConfigModifier(entry.getKey(), entry.getValue());
        }
    }

    public List<ServerPagesApp> getApps() {
        return this.apps;
    }

    public List<ViewRenderer> getRenderers() {
        return this.renderers;
    }

    public Map<String, Map<String, String>> getViewsConfig() {
        return this.viewsConfig;
    }

    public Map<String, Map<String, String>> viewsConfig(Map<String, Map<String, String>> viewsConfig) {
        this.viewsConfig = viewsConfig;
        return viewsConfig;
    }

    public void addRenderers(ViewRenderer ... renderers) {
        this.checkLocked();
        for (ViewRenderer renderer : renderers) {
            String key = renderer.getConfigurationKey();
            boolean add = true;
            for (ViewRenderer ren : this.renderers) {
                if (!ren.getConfigurationKey().equals(key)) continue;
                add = false;
                break;
            }
            if (!add) continue;
            this.renderers.add(renderer);
        }
    }

    public ViewConfigurable<Configuration> getConfigurable() {
        return this.configurable;
    }

    public <T extends Configuration> void setConfigurable(ViewConfigurable<T> configurable) {
        this.configurable = configurable;
    }

    public void addConfigModifier(String name, ViewRendererConfigurationModifier modifier) {
        this.checkLocked();
        this.configModifiers.put((Object)name, (Object)modifier);
    }

    public Multimap<String, ViewRendererConfigurationModifier> getConfigModifiers() {
        return this.configModifiers;
    }

    public boolean isPrintConfiguration() {
        return this.printConfig;
    }

    public void printConfiguration() {
        this.printConfig = true;
    }

    public void lock() {
        this.locked = true;
    }

    public boolean isLocked() {
        return this.locked;
    }

    public void extendAssets(String app, AssetSources sources) {
        this.checkAppNotInitialized(app);
        if (!this.assetExtensions.containsKey(app)) {
            this.assetExtensions.put(app, new AssetSources());
        }
        this.assetExtensions.get(app).merge(sources);
    }

    public void extendViews(String app, ViewRestSources sources) {
        this.checkAppNotInitialized(app);
        if (!this.restExtensions.containsKey(app)) {
            this.restExtensions.put(app, new ViewRestSources());
        }
        this.restExtensions.get(app).merge(sources);
    }

    public AssetSources getAssetExtensions(String app) {
        return this.assetExtensions.get(app);
    }

    public ViewRestSources getViewExtensions(String app) {
        return this.restExtensions.get(app);
    }

    private void checkLocked() {
        Preconditions.checkState((!this.locked ? 1 : 0) != 0, (Object)"Global initialization already performed");
    }

    private void checkAppNotInitialized(String app) {
        for (ServerPagesApp spa : this.apps) {
            if (!spa.name.equals(app)) continue;
            Preconditions.checkState((!spa.isStarted() ? 1 : 0) != 0, (String)"Can't extend already initialized server pages application %s", (Object)app);
            break;
        }
    }
}

