/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.guicey.gsp.app.asset;

import com.google.common.base.CharMatcher;
import com.google.common.collect.Multimap;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import ru.vyarus.dropwizard.guice.module.installer.util.PathUtils;
import ru.vyarus.guicey.gsp.app.util.ResourceLookup;

public class AssetLookup
implements Serializable {
    private final String primaryLocation;
    private final Multimap<String, String> locations;

    public AssetLookup(String primaryLocation, Multimap<String, String> locations) {
        this.primaryLocation = primaryLocation;
        this.locations = locations;
    }

    public String getPrimaryLocation() {
        return this.primaryLocation;
    }

    public Multimap<String, String> getLocations() {
        return this.locations;
    }

    public String getRelativePath(String path) {
        String relativePath = CharMatcher.is((char)'/').trimLeadingFrom((CharSequence)path);
        if (path.startsWith(this.primaryLocation)) {
            relativePath = path.substring(this.primaryLocation.length());
        }
        return relativePath;
    }

    public String lookup(String path) {
        String url;
        String relativePath = this.getRelativePath(path);
        String res = null;
        String assetPath = CharMatcher.is((char)'/').trimLeadingFrom((CharSequence)relativePath);
        Iterator iterator = this.locations.keySet().iterator();
        while (iterator.hasNext() && (!assetPath.startsWith(url = (String)iterator.next()) || (res = ResourceLookup.lookup(url.length() > 0 ? assetPath.substring(url.length()) : assetPath, this.locations.get((Object)url))) == null)) {
        }
        return res;
    }

    public List<String> getMatchingLocations(String path) {
        ArrayList<String> matches = new ArrayList<String>();
        String relativePath = this.getRelativePath(path);
        String assetPath = CharMatcher.is((char)'/').trimLeadingFrom((CharSequence)relativePath);
        for (String url : this.locations.keySet()) {
            if (!assetPath.startsWith(url)) continue;
            for (String loc : this.locations.get((Object)url)) {
                matches.add(PathUtils.trimSlashes((String)(url + loc)).replace("/", "."));
            }
        }
        return matches;
    }
}

