/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.guicey.gsp.app.ext;

import com.google.common.base.Preconditions;
import ru.vyarus.dropwizard.guice.module.installer.bundle.GuiceyBundle;
import ru.vyarus.dropwizard.guice.module.installer.bundle.GuiceyEnvironment;
import ru.vyarus.guicey.gsp.ServerPagesBundle;
import ru.vyarus.guicey.gsp.app.GlobalConfig;
import ru.vyarus.guicey.gsp.app.asset.AssetSources;
import ru.vyarus.guicey.gsp.app.ext.DelayedConfigurationCallback;
import ru.vyarus.guicey.gsp.app.rest.mapping.ViewRestSources;

public class ServerPagesAppExtensionBundle
implements GuiceyBundle {
    private final String name;
    private final AssetSources assets = new AssetSources();
    private DelayedConfigurationCallback delayedConfigCallback;
    private final ViewRestSources views = new ViewRestSources();

    protected ServerPagesAppExtensionBundle(String name) {
        this.name = name;
    }

    public void run(GuiceyEnvironment environment) throws Exception {
        GlobalConfig config = (GlobalConfig)environment.sharedStateOrFail(ServerPagesBundle.class, "Either server pages support bundle was not installed (use %s.builder() to create bundle)  or it was installed after '%s' application extension bundle", new Object[]{ServerPagesBundle.class.getSimpleName(), this.name});
        if (this.delayedConfigCallback != null) {
            this.delayedConfigCallback.configure(environment, this.assets, this.views);
        }
        config.extendAssets(this.name, this.assets);
        config.extendViews(this.name, this.views);
    }

    public static class AppExtensionBuilder {
        private final ServerPagesAppExtensionBundle bundle;

        public AppExtensionBuilder(String name) {
            this.bundle = new ServerPagesAppExtensionBundle(name);
        }

        public AppExtensionBuilder mapViews(String subUrl, String prefix) {
            this.bundle.views.map(subUrl, prefix);
            return this;
        }

        public AppExtensionBuilder attachAssets(String path) {
            this.bundle.assets.attach(path);
            return this;
        }

        public AppExtensionBuilder attachAssets(String subUrl, String path) {
            this.bundle.assets.attach(subUrl, path);
            return this;
        }

        public AppExtensionBuilder delayedConfiguration(DelayedConfigurationCallback callback) {
            Preconditions.checkArgument((this.bundle.delayedConfigCallback == null ? 1 : 0) != 0, (Object)"Only one delayed configuration could be registered");
            this.bundle.delayedConfigCallback = callback;
            return this;
        }

        public ServerPagesAppExtensionBundle build() {
            return this.bundle;
        }
    }
}

