/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.guicey.gsp.app.rest.log;

import com.fasterxml.classmate.ResolvedType;
import com.fasterxml.classmate.TypeResolver;
import io.dropwizard.jersey.DropwizardResourceConfig;
import java.lang.reflect.Type;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;
import org.glassfish.jersey.server.model.Resource;
import org.glassfish.jersey.server.model.ResourceMethod;
import ru.vyarus.dropwizard.guice.module.installer.util.PathUtils;
import ru.vyarus.guicey.gsp.app.rest.log.ViewPath;
import ru.vyarus.guicey.gsp.views.template.Template;

public class RestPathsAnalyzer {
    private static final TypeResolver TYPE_RESOLVER = new TypeResolver();
    private final Set<ViewPath> paths = new HashSet<ViewPath>();

    public static RestPathsAnalyzer build(DropwizardResourceConfig config) {
        RestPathsAnalyzer analyzer = new RestPathsAnalyzer();
        for (Class cls : config.getClasses()) {
            Resource resource;
            if (!cls.isAnnotationPresent(Template.class) || (resource = Resource.from((Class)cls)) == null) continue;
            RestPathsAnalyzer.populate("", cls, false, resource, analyzer.paths);
        }
        for (Resource resource : config.getResources()) {
            for (Resource childRes : resource.getChildResources()) {
                for (Class childResHandlerClass : childRes.getHandlerClasses()) {
                    if (!childResHandlerClass.isAnnotationPresent(Template.class)) continue;
                    RestPathsAnalyzer.populate(resource.getPath(), childResHandlerClass, false, childRes, analyzer.paths);
                }
            }
        }
        return analyzer;
    }

    public Set<ViewPath> select(String app) {
        TreeSet<ViewPath> res = new TreeSet<ViewPath>();
        String prefix = PathUtils.leadingSlash((String)PathUtils.trailingSlash((String)app));
        for (ViewPath path : this.paths) {
            if (!path.getUrl().startsWith(prefix)) continue;
            res.add(path);
        }
        return res;
    }

    private static void populate(String rootPath, Class<?> klass, boolean isLocator, Resource resource, Set<ViewPath> handles) {
        String basePath = rootPath;
        if (!isLocator) {
            basePath = PathUtils.path((String[])new String[]{rootPath, resource.getPath()});
        }
        for (ResourceMethod method : resource.getResourceMethods()) {
            handles.add(new ViewPath(method, resource, klass, basePath));
        }
        for (Resource childResource : resource.getChildResources()) {
            for (ResourceMethod method : childResource.getAllMethods()) {
                String path;
                if (method.getType() == ResourceMethod.JaxrsType.RESOURCE_METHOD) {
                    path = PathUtils.path((String[])new String[]{basePath, childResource.getPath()});
                    handles.add(new ViewPath(method, childResource, klass, path));
                    continue;
                }
                if (method.getType() != ResourceMethod.JaxrsType.SUB_RESOURCE_LOCATOR) continue;
                path = PathUtils.path((String[])new String[]{basePath, childResource.getPath()});
                ResolvedType responseType = TYPE_RESOLVER.resolve(method.getInvocable().getResponseType(), new Type[0]);
                Class erasedType = !responseType.getTypeBindings().isEmpty() ? responseType.getTypeBindings().getBoundType(0).getErasedType() : responseType.getErasedType();
                Resource erasedTypeResource = Resource.from((Class)erasedType);
                if (erasedTypeResource == null) {
                    handles.add(new ViewPath(method, childResource, erasedType, path));
                    continue;
                }
                RestPathsAnalyzer.populate(path, erasedType, true, erasedTypeResource, handles);
            }
        }
    }
}

