/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.guicey.gsp.app.util;

import com.google.common.base.CharMatcher;
import com.google.common.base.MoreObjects;
import java.util.Iterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.vyarus.dropwizard.guice.module.installer.util.PathUtils;
import ru.vyarus.guicey.gsp.app.asset.AssetLookup;
import ru.vyarus.guicey.gsp.views.template.TemplateNotFoundException;

public final class ResourceLookup {
    private static final Logger LOGGER = LoggerFactory.getLogger(ResourceLookup.class);

    private ResourceLookup() {
    }

    public static String lookup(Class base, String path) {
        String resourceBaseLocation = PathUtils.path((String[])new String[]{PathUtils.packagePath((Class)base), CharMatcher.is((char)'/').trimLeadingFrom((CharSequence)path)});
        return ResourceLookup.exists(resourceBaseLocation) ? resourceBaseLocation : null;
    }

    public static String lookup(String path, Iterable<String> rootPaths) {
        String templatePath = CharMatcher.is((char)'/').trimLeadingFrom((CharSequence)path);
        Iterator<String> it = rootPaths.iterator();
        String res = null;
        while (res == null && it.hasNext()) {
            String location = it.next();
            if (!ResourceLookup.exists(location + templatePath)) continue;
            res = location + templatePath;
        }
        return res;
    }

    public static String lookupOrFail(String path, AssetLookup assets) throws TemplateNotFoundException {
        String lookup = assets.lookup(path);
        if (lookup == null) {
            String err = String.format("Template %s not found in locations: %s", path, assets.getMatchingLocations(path));
            LOGGER.info(err);
            throw new TemplateNotFoundException(err);
        }
        return lookup;
    }

    public static boolean exists(String path) {
        ClassLoader loader = (ClassLoader)MoreObjects.firstNonNull((Object)Thread.currentThread().getContextClassLoader(), (Object)ResourceLookup.class.getClassLoader());
        return loader.getResource(CharMatcher.is((char)'/').trimLeadingFrom((CharSequence)path)) != null;
    }

    public static void existsOrFail(String path) throws TemplateNotFoundException {
        if (!ResourceLookup.exists(path)) {
            String err = String.format("Template not found on path %s", path);
            LOGGER.info(err);
            throw new TemplateNotFoundException(err);
        }
    }
}

