/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.guicey.gsp.app.asset.servlet;

import io.dropwizard.servlets.assets.AssetServlet;
import java.net.URL;
import java.nio.charset.Charset;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.vyarus.dropwizard.guice.module.installer.util.PathUtils;
import ru.vyarus.guicey.gsp.app.asset.AssetLookup;

public class AssetResolutionServlet
extends AssetServlet {
    private static final long serialVersionUID = 6393345594784987909L;
    private final transient Logger logger = LoggerFactory.getLogger(AssetResolutionServlet.class);
    private final AssetLookup assets;

    public AssetResolutionServlet(AssetLookup assets, String uriPath, @Nullable String indexFile, @Nullable Charset defaultCharset) {
        super(assets.getPrimaryLocation(), uriPath, indexFile, defaultCharset);
        this.assets = assets;
    }

    protected URL getResourceUrl(String absolutePath) {
        String realPath = absolutePath;
        if (!PathUtils.trailingSlash((String)realPath).equals(this.assets.getPrimaryLocation())) {
            realPath = this.assets.lookup(realPath);
        }
        if (realPath == null && this.logger.isInfoEnabled()) {
            String err = String.format("Asset '%s' not found in locations: %s", this.assets.getRelativePath(absolutePath), this.assets.getMatchingLocations(absolutePath));
            this.logger.info(err);
        }
        return super.getResourceUrl(realPath);
    }
}

