/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.guicey.gsp.app.filter.redirect;

import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.vyarus.guicey.spa.filter.SpaUtils;

public class SpaSupport {
    private static final String SPA_ROUTE_POSSIBILITY = "SpaRedirect.SPA_ROUTE_POSSIBILITY";
    private final Logger logger = LoggerFactory.getLogger(SpaSupport.class);
    private final boolean enabled;
    private final String rootMapping;
    private final String target;
    private final Pattern noRedirect;

    public SpaSupport(boolean enabled, String rootMapping, String target, String noRedirectRegex) {
        this.enabled = enabled;
        this.rootMapping = rootMapping;
        this.target = target;
        this.noRedirect = Pattern.compile(noRedirectRegex);
    }

    public void markPossibleSpaRoute(HttpServletRequest req, HttpServletResponse res) {
        if (!this.enabled) {
            return;
        }
        String requestURI = req.getRequestURI();
        if (SpaUtils.isRootPage((String)requestURI, (String)this.rootMapping)) {
            SpaUtils.noCache((HttpServletResponse)res);
        } else {
            req.setAttribute(SPA_ROUTE_POSSIBILITY, (Object)true);
            this.logger.debug("Request {} could be a SPA route", (Object)requestURI);
        }
    }

    public boolean redirect(HttpServletRequest req, HttpServletResponse res, int code) {
        if (this.enabled && code == 404 && req.getAttribute(SPA_ROUTE_POSSIBILITY) != null && SpaUtils.isSpaRoute((HttpServletRequest)req, (Pattern)this.noRedirect)) {
            try {
                this.logger.debug("Perform SPA route redirect: {} => {}", (Object)req.getRequestURI(), (Object)this.target);
                req.removeAttribute(SPA_ROUTE_POSSIBILITY);
                SpaUtils.doRedirect((HttpServletRequest)req, (HttpServletResponse)res, (String)this.target);
                return true;
            }
            catch (Exception ex) {
                this.logger.error("Failed to perform SPA redirect for " + req.getRequestURI(), (Throwable)ex);
            }
        }
        return false;
    }
}

