/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.guicey.gsp.app.util;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.vyarus.guicey.gsp.app.asset.AssetLookup;
import ru.vyarus.guicey.gsp.views.template.TemplateNotFoundException;

public final class ResourceLookup {
    private static final Logger LOGGER = LoggerFactory.getLogger(ResourceLookup.class);

    private ResourceLookup() {
    }

    public static String lookupOrFail(String path, AssetLookup assets) throws TemplateNotFoundException {
        String lookup = assets.lookupPath(path);
        if (lookup == null) {
            String err = String.format("Template %s not found in locations: %s", path, assets.getMatchingLocations(path));
            LOGGER.info(err);
            throw new TemplateNotFoundException(err);
        }
        return lookup;
    }

    public static void existsOrFail(String path, AssetLookup assets) throws TemplateNotFoundException {
        if (assets.load(path) == null) {
            String err = String.format("Template not found on path %s", path);
            LOGGER.info(err);
            throw new TemplateNotFoundException(err);
        }
    }
}

