/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.guicey.gsp.app.filter.redirect;

import java.io.IOException;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.vyarus.dropwizard.guice.module.installer.util.PathUtils;
import ru.vyarus.guicey.gsp.app.asset.AssetLookup;
import ru.vyarus.guicey.gsp.app.filter.redirect.ErrorRedirect;
import ru.vyarus.guicey.gsp.app.rest.mapping.ViewRestLookup;
import ru.vyarus.guicey.gsp.app.util.TemplateRequest;
import ru.vyarus.guicey.gsp.views.template.TemplateContext;

public class TemplateRedirect {
    private static final ThreadLocal<TemplateContext> CONTEXT_TEMPLATE = new ThreadLocal();
    private final Logger logger = LoggerFactory.getLogger(TemplateRedirect.class);
    private final Servlet restServlet;
    private final String app;
    private final String mapping;
    private final ViewRestLookup views;
    private final AssetLookup assets;
    private final ErrorRedirect errorRedirect;
    private String rootPath;
    private String restContextPath;
    private String restServletMapping;

    public TemplateRedirect(Servlet restServlet, String app, String mapping, ViewRestLookup views, AssetLookup assets, ErrorRedirect errorRedirect) {
        this.restServlet = restServlet;
        this.app = app;
        this.mapping = mapping;
        this.assets = assets;
        this.views = views;
        this.errorRedirect = errorRedirect;
    }

    public void setRootPath(String contextPath, String servletMapping) {
        this.restContextPath = contextPath;
        this.restServletMapping = servletMapping;
        this.rootPath = PathUtils.path((String[])new String[]{contextPath, servletMapping});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void redirect(HttpServletRequest request, HttpServletResponse response, String page, boolean directTemplate) throws IOException, ServletException {
        String contextUrl = this.views.lookupSubContext(page);
        String restPrefix = this.views.lookupRestPrefix(contextUrl);
        CONTEXT_TEMPLATE.set(new TemplateContext(this.app, this.mapping, contextUrl, restPrefix, directTemplate, this.assets, this.errorRedirect, request, response));
        try {
            String path = PathUtils.path((String[])new String[]{this.rootPath, this.views.buildRestPath(contextUrl, page)});
            this.logger.debug("Redirecting '{}' to view path '{}' (app context: {}, rest mapping prefix: {})", new Object[]{page, path, contextUrl.isEmpty() ? "/" : contextUrl, "/" + restPrefix});
            this.restServlet.service((ServletRequest)new TemplateRequest(request, path, this.restContextPath, this.restServletMapping), (ServletResponse)response);
        }
        finally {
            CONTEXT_TEMPLATE.remove();
        }
    }

    public ErrorRedirect getErrorRedirect() {
        return this.errorRedirect;
    }

    public String getRootPath() {
        return this.rootPath;
    }

    public static TemplateContext templateContext() {
        return CONTEXT_TEMPLATE.get();
    }
}

