/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.guicey.gsp.app.asset;

import com.google.common.base.CharMatcher;
import com.google.common.collect.Multimap;
import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import ru.vyarus.dropwizard.guice.module.installer.util.PathUtils;

public class AssetLookup
implements Serializable {
    private final String primaryLocation;
    private final Multimap<String, String> locations;
    private final Multimap<String, ClassLoader> loaders;

    public AssetLookup(String primaryLocation, Multimap<String, String> locations, Multimap<String, ClassLoader> loaders) {
        this.primaryLocation = primaryLocation;
        this.locations = locations;
        this.loaders = loaders;
    }

    public String getPrimaryLocation() {
        return this.primaryLocation;
    }

    public Multimap<String, String> getLocations() {
        return this.locations;
    }

    public Multimap<String, ClassLoader> getLoaders() {
        return this.loaders;
    }

    public String getRelativePath(String path) {
        String relativePath = CharMatcher.is((char)'/').trimLeadingFrom((CharSequence)path);
        if (path.startsWith(this.primaryLocation)) {
            relativePath = path.substring(this.primaryLocation.length());
        } else if (relativePath.length() == this.primaryLocation.length() - 1 && this.primaryLocation.startsWith(relativePath)) {
            relativePath = "";
        }
        return relativePath;
    }

    public URL lookupUrl(String url) {
        AssetLocation res = this.lookup(url);
        return res == null ? null : res.getUrl();
    }

    public String lookupPath(String url) {
        AssetLocation res = this.lookup(url);
        return res == null ? null : res.getPath();
    }

    public URL load(String assetPath) {
        URL res;
        ClassLoader loader;
        String path = CharMatcher.is((char)'/').trimLeadingFrom((CharSequence)assetPath);
        AssetLocation location = null;
        Iterator<ClassLoader> iterator = this.getMatchingLoaders(path).iterator();
        while (iterator.hasNext() && (location = this.find(path, loader = iterator.next())) == null) {
        }
        ClassLoader contextLoader = Thread.currentThread().getContextClassLoader();
        if (location == null && contextLoader != null) {
            location = this.find(path, contextLoader);
        }
        URL uRL = res = location == null ? null : location.getUrl();
        if (res == null && !assetPath.startsWith("/")) {
            res = this.lookupUrl(assetPath);
        }
        return res;
    }

    public AssetLocation lookup(String path) {
        String relativePath = this.getRelativePath(path);
        AssetLocation res = null;
        String assetPath = CharMatcher.is((char)'/').trimLeadingFrom((CharSequence)relativePath);
        for (String subUrl : this.locations.keySet()) {
            String pkg;
            if (!assetPath.startsWith(subUrl)) continue;
            String targetPath = subUrl.length() > 0 ? assetPath.substring(subUrl.length()) : assetPath;
            Iterator iterator = this.locations.get((Object)subUrl).iterator();
            while (iterator.hasNext() && (res = this.find((pkg = (String)iterator.next()) + targetPath, this.loaders.get((Object)pkg))) == null) {
            }
            if (res == null) continue;
            break;
        }
        return res;
    }

    public List<String> getMatchingLocations(String url) {
        ArrayList<String> matches = new ArrayList<String>();
        String relativePath = this.getRelativePath(url);
        String assetPath = CharMatcher.is((char)'/').trimLeadingFrom((CharSequence)relativePath);
        for (String subUrl : this.locations.keySet()) {
            if (!assetPath.startsWith(subUrl)) continue;
            for (String loc : this.locations.get((Object)subUrl)) {
                matches.add(PathUtils.trimSlashes((String)(subUrl + loc)).replace("/", "."));
            }
        }
        return matches;
    }

    public Set<ClassLoader> getMatchingLoaders(String assetPath) {
        String path = CharMatcher.is((char)'/').trimLeadingFrom((CharSequence)assetPath);
        LinkedHashSet<ClassLoader> res = new LinkedHashSet<ClassLoader>();
        for (String prefix : this.loaders.keySet()) {
            if (!path.startsWith(prefix)) continue;
            res.addAll(this.loaders.get((Object)prefix));
        }
        return res;
    }

    private AssetLocation find(String path, Iterable<ClassLoader> loaders) {
        ClassLoader loader;
        AssetLocation res = null;
        Iterator<ClassLoader> iterator = loaders.iterator();
        while (iterator.hasNext() && (res = this.find(path, loader = iterator.next())) == null) {
        }
        return res;
    }

    private AssetLocation find(String path, ClassLoader loader) {
        URL target = loader.getResource(path);
        return target != null ? new AssetLocation(path, loader, target) : null;
    }

    public static class AssetLocation {
        private final String path;
        private final ClassLoader loader;
        private final URL url;

        public AssetLocation(String path, ClassLoader loader, URL url) {
            this.path = PathUtils.leadingSlash((String)path);
            this.loader = loader;
            this.url = url;
        }

        public String getPath() {
            return this.path;
        }

        public ClassLoader getLoader() {
            return this.loader;
        }

        public URL getUrl() {
            return this.url;
        }
    }
}

