/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.guicey.gsp.app.rest.support;

import io.dropwizard.views.View;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.Locale;
import javax.inject.Inject;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import javax.ws.rs.ext.Provider;
import org.glassfish.jersey.message.internal.HeaderValueException;
import org.glassfish.jersey.server.monitoring.RequestEvent;
import org.glassfish.jersey.spi.ExtendedExceptionMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.vyarus.dropwizard.guice.module.installer.feature.jersey.JerseyManaged;
import ru.vyarus.dropwizard.guice.module.installer.util.PathUtils;
import ru.vyarus.guicey.gsp.app.filter.redirect.ErrorRedirect;
import ru.vyarus.guicey.gsp.app.filter.redirect.TemplateRedirect;
import ru.vyarus.guicey.gsp.views.template.ErrorTemplateView;
import ru.vyarus.guicey.gsp.views.template.TemplateContext;
import ru.vyarus.guicey.gsp.views.template.TemplateNotFoundException;
import ru.vyarus.guicey.gsp.views.template.TemplateView;

@Provider
@JerseyManaged
public class DirectTemplateExceptionMapper
implements ExtendedExceptionMapper<NotFoundException> {
    private final Logger logger = LoggerFactory.getLogger(DirectTemplateExceptionMapper.class);
    @Inject
    private javax.inject.Provider<UriInfo> info;
    @Inject
    private javax.inject.Provider<HttpHeaders> headers;

    public boolean isMappable(NotFoundException exception) {
        return DirectTemplateExceptionMapper.isDirectTemplateRequest() && ((UriInfo)this.info.get()).getMatchedResources().isEmpty();
    }

    public Response toResponse(NotFoundException exception) {
        Response res;
        TemplateContext context = TemplateContext.getInstance();
        String path = ((UriInfo)this.info.get()).getPath().substring(context.getRestPrefix().length() - 1);
        String fullPath = PathUtils.path((String[])new String[]{context.getRestSubContext(), path});
        this.logger.debug("Direct template rendering: '{}'", (Object)fullPath);
        try {
            res = this.renderTemplate(path);
        }
        catch (TemplateNotFoundException ex) {
            String message = "Template '" + path + "' not found";
            TemplateContext.getInstance().redirectError((Throwable)new NotFoundException(message, (Throwable)ex));
            res = Response.status((int)404, (String)message).build();
        }
        catch (Throwable ex) {
            this.logger.error("Error rendering direct template ex", ex);
            TemplateContext.getInstance().redirectError(ex);
            res = Response.serverError().build();
        }
        return res;
    }

    protected static boolean canHandle(RequestEvent event) {
        return event.getType() == RequestEvent.Type.ON_EXCEPTION && DirectTemplateExceptionMapper.isDirectTemplateRequest() && event.getUriInfo().getMatchedResources().isEmpty() && event.getException() instanceof NotFoundException && event.getExceptionCause() == RequestEvent.ExceptionCause.ORIGINAL;
    }

    private static boolean isDirectTemplateRequest() {
        TemplateContext context = TemplateRedirect.templateContext();
        return context != null && context.isDirectTemplate();
    }

    private Response renderTemplate(String path) throws Exception {
        TemplateView model = ErrorRedirect.hasContextError() ? new ErrorTemplateView(path) : new TemplateView(path);
        TemplateContext context = TemplateRedirect.templateContext();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        context.getDirectTemplateRenderer().render((View)model, this.detectLocale(), (OutputStream)out);
        return Response.ok((Object)out.toByteArray()).type(MediaType.TEXT_HTML_TYPE).build();
    }

    protected Locale detectLocale() {
        List languages;
        try {
            languages = ((HttpHeaders)this.headers.get()).getAcceptableLanguages();
        }
        catch (HeaderValueException e) {
            throw new WebApplicationException(e.getMessage(), Response.Status.BAD_REQUEST);
        }
        for (Locale locale : languages) {
            if (locale.toString().contains("*")) continue;
            return locale;
        }
        return Locale.getDefault();
    }
}

