/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.guicey.gsp.info;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.dropwizard.views.common.ViewRenderer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.inject.Singleton;
import ru.vyarus.guicey.gsp.app.GlobalConfig;
import ru.vyarus.guicey.gsp.app.ServerPagesApp;
import ru.vyarus.guicey.gsp.info.model.GspApp;

@Singleton
public class GspInfoService {
    private final GlobalConfig config;

    public GspInfoService(GlobalConfig config) {
        this.config = config;
    }

    public List<String> getViewRendererNames() {
        this.checkLock();
        return this.config.getRenderers().stream().map(ViewRenderer::getConfigurationKey).collect(Collectors.toList());
    }

    public List<ViewRenderer> getViewRenderers() {
        this.checkLock();
        return ImmutableList.copyOf(this.config.getRenderers());
    }

    public Map<String, Map<String, String>> getViewsConfig() {
        this.checkLock();
        return ImmutableMap.copyOf(this.config.getViewsConfig());
    }

    public List<GspApp> getApplications() {
        this.checkLock();
        ArrayList<GspApp> res = new ArrayList<GspApp>();
        for (ServerPagesApp app : this.config.getApps()) {
            res.add(app.getInfo(this.config));
        }
        return res;
    }

    public GspApp getApplication(String name) {
        this.checkLock();
        for (ServerPagesApp app : this.config.getApps()) {
            if (!name.equals(app.getName())) continue;
            return app.getInfo(this.config);
        }
        return null;
    }

    private void checkLock() {
        Preconditions.checkArgument((boolean)this.config.isLocked(), (Object)"GSP bundle is not yet initialized");
    }
}

