/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.guicey.gsp.views;

import io.dropwizard.core.Configuration;
import io.dropwizard.views.common.ViewBundle;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.vyarus.dropwizard.guice.module.installer.util.Reporter;
import ru.vyarus.guicey.gsp.app.GlobalConfig;
import ru.vyarus.guicey.gsp.views.ViewRendererConfigurationModifier;

public class ConfiguredViewBundle
extends ViewBundle<Configuration> {
    private final Logger logger = LoggerFactory.getLogger(ConfiguredViewBundle.class);
    private final GlobalConfig globalConfig;

    public ConfiguredViewBundle(GlobalConfig globalConfig) {
        super(globalConfig.getRenderers());
        this.globalConfig = globalConfig;
    }

    public Map<String, Map<String, String>> getViewConfiguration(Configuration configuration) {
        Map<String, Map<String, String>> config;
        this.globalConfig.lock();
        if (this.globalConfig.getConfigurable() == null) {
            config = new HashMap();
        } else {
            config = this.globalConfig.getConfigurable().getViewConfiguration((Object)configuration);
            if (config == null) {
                config = new HashMap();
            }
        }
        for (String key : this.globalConfig.getConfigModifiers().keySet()) {
            if (!config.containsKey(key)) {
                config.put(key, new HashMap());
            }
            Map<String, String> cfg = config.get(key);
            for (ViewRendererConfigurationModifier modifier : this.globalConfig.getConfigModifiers().get((Object)key)) {
                modifier.modify(cfg);
            }
        }
        if (this.globalConfig.isPrintConfiguration()) {
            this.logger.info("Views configuration: {}{}", (Object)Reporter.NEWLINE, (Object)ConfiguredViewBundle.renderConfig(config));
        }
        return this.globalConfig.viewsConfig(config);
    }

    private static String renderConfig(Map<String, Map<String, String>> config) {
        StringBuilder res = new StringBuilder(Reporter.NEWLINE);
        if (config.isEmpty()) {
            res.append("    ").append("empty configuration").append(Reporter.NEWLINE);
        }
        for (Map.Entry<String, Map<String, String>> entry : config.entrySet()) {
            res.append("    ").append(entry.getKey()).append(Reporter.NEWLINE);
            if (entry.getValue().isEmpty()) {
                res.append(Reporter.NEWLINE);
            }
            for (Map.Entry<String, String> ventry : entry.getValue().entrySet()) {
                res.append("    ").append("    ").append(ventry.getKey()).append(" = ").append(ventry.getValue()).append(Reporter.NEWLINE);
            }
        }
        return res.toString();
    }
}

