/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.guicey.gsp.app.asset;

import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import ru.vyarus.dropwizard.guice.module.installer.util.PathUtils;
import ru.vyarus.guicey.gsp.app.asset.AssetLookup;

public class AssetSources {
    public static final ClassLoader DEFAULT_LOADER = AssetLookup.class.getClassLoader();
    private final Multimap<String, String> locations = LinkedHashMultimap.create();
    private final Multimap<String, ClassLoader> loaders = LinkedHashMultimap.create();

    public void attach(String location) {
        this.attach("/", location);
    }

    public void attach(String url, String location) {
        this.attach(url, location, null);
    }

    public void attach(String location, ClassLoader loader) {
        this.attach("/", location, loader);
    }

    public void attach(String url, String location, ClassLoader loader) {
        String path = PathUtils.normalizeClasspathPath((String)location);
        this.locations.put((Object)PathUtils.normalizeRelativePath((String)url), (Object)path);
        this.loaders.put((Object)path, (Object)(loader == null ? DEFAULT_LOADER : loader));
    }

    public Multimap<String, String> getLocations() {
        return this.locations;
    }

    public Multimap<String, ClassLoader> getLoaders() {
        return this.loaders;
    }

    public void merge(AssetSources assets) {
        this.locations.putAll(assets.locations);
        this.loaders.putAll(assets.loaders);
    }
}

