/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.guicey.gsp.app.rest.mapping;

import com.google.common.base.CharMatcher;
import java.util.Map;
import ru.vyarus.dropwizard.guice.module.installer.util.PathUtils;

public class ViewRestLookup {
    private final Map<String, String> prefixes;

    public ViewRestLookup(Map<String, String> prefixes) {
        this.prefixes = prefixes;
    }

    public String getPrimaryMapping() {
        return this.prefixes.get("");
    }

    public Map<String, String> getPrefixes() {
        return this.prefixes;
    }

    public String lookupSubContext(String path) {
        String relativePath = CharMatcher.is((char)'/').trimLeadingFrom((CharSequence)path);
        String res = null;
        for (Map.Entry<String, String> entry : this.prefixes.entrySet()) {
            String url = entry.getKey();
            if (!relativePath.startsWith(url)) continue;
            res = url;
            break;
        }
        return res;
    }

    public String lookupRestPrefix(String context) {
        return this.prefixes.get(context);
    }

    public String buildRestPath(String subContext, String path) {
        String prefix = this.prefixes.get(subContext);
        String relativeUrl = path.startsWith(subContext) ? path.substring(subContext.length()) : path;
        return PathUtils.path((String[])new String[]{prefix, relativeUrl});
    }
}

