/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.guicey.gsp.app.rest.support;

import jakarta.inject.Inject;
import jakarta.ws.rs.NotFoundException;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriInfo;
import jakarta.ws.rs.ext.Provider;
import org.glassfish.jersey.server.monitoring.RequestEvent;
import org.glassfish.jersey.spi.ExtendedExceptionMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.vyarus.dropwizard.guice.module.installer.feature.jersey.JerseyManaged;
import ru.vyarus.dropwizard.guice.module.installer.util.PathUtils;
import ru.vyarus.guicey.gsp.app.filter.redirect.ErrorRedirect;
import ru.vyarus.guicey.gsp.app.filter.redirect.TemplateRedirect;
import ru.vyarus.guicey.gsp.views.template.ErrorTemplateView;
import ru.vyarus.guicey.gsp.views.template.TemplateContext;
import ru.vyarus.guicey.gsp.views.template.TemplateNotFoundException;
import ru.vyarus.guicey.gsp.views.template.TemplateView;

@Provider
@JerseyManaged
public class DirectTemplateExceptionMapper
implements ExtendedExceptionMapper<NotFoundException> {
    private final Logger logger = LoggerFactory.getLogger(DirectTemplateExceptionMapper.class);
    @Inject
    private jakarta.inject.Provider<UriInfo> info;

    public boolean isMappable(NotFoundException exception) {
        return DirectTemplateExceptionMapper.isDirectTemplateRequest() && ((UriInfo)this.info.get()).getMatchedResources().isEmpty();
    }

    public Response toResponse(NotFoundException exception) {
        Response res;
        TemplateContext context = TemplateContext.getInstance();
        String path = ((UriInfo)this.info.get()).getPath().substring(context.getRestPrefix().length() - 1);
        String fullPath = PathUtils.path((String[])new String[]{context.getRestSubContext(), path});
        this.logger.debug("Direct template rendering: '{}'", (Object)fullPath);
        try {
            res = Response.ok((Object)((Object)(ErrorRedirect.hasContextError() ? new ErrorTemplateView(path) : new TemplateView(path)))).type(MediaType.TEXT_HTML_TYPE).build();
        }
        catch (TemplateNotFoundException ex) {
            String message = "Template '" + path + "' not found";
            TemplateContext.getInstance().redirectError((Throwable)new NotFoundException(message, (Throwable)ex));
            res = Response.status((int)404, (String)message).build();
        }
        catch (Throwable ex) {
            this.logger.error("Error rendering direct template ex", ex);
            TemplateContext.getInstance().redirectError((Throwable)exception);
            res = Response.serverError().build();
        }
        return res;
    }

    protected static boolean canHandle(RequestEvent event) {
        return event.getType() == RequestEvent.Type.ON_EXCEPTION && DirectTemplateExceptionMapper.isDirectTemplateRequest() && event.getUriInfo().getMatchedResources().isEmpty() && event.getException() instanceof NotFoundException && event.getExceptionCause() == RequestEvent.ExceptionCause.ORIGINAL;
    }

    private static boolean isDirectTemplateRequest() {
        TemplateContext context = TemplateRedirect.templateContext();
        return context != null && context.isDirectTemplate();
    }
}

