/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.guicey.gsp;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.inject.Module;
import io.dropwizard.core.Configuration;
import io.dropwizard.core.ConfiguredBundle;
import io.dropwizard.core.setup.Environment;
import io.dropwizard.views.common.ViewConfigurable;
import io.dropwizard.views.common.ViewRenderer;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.vyarus.dropwizard.guice.module.context.unique.item.UniqueGuiceyBundle;
import ru.vyarus.dropwizard.guice.module.installer.bundle.GuiceyBootstrap;
import ru.vyarus.dropwizard.guice.module.installer.bundle.GuiceyEnvironment;
import ru.vyarus.dropwizard.guice.module.installer.util.PathUtils;
import ru.vyarus.dropwizard.guice.module.installer.util.Reporter;
import ru.vyarus.dropwizard.guice.module.lifecycle.GuiceyLifecycleAdapter;
import ru.vyarus.dropwizard.guice.module.lifecycle.GuiceyLifecycleListener;
import ru.vyarus.dropwizard.guice.module.lifecycle.event.run.ApplicationRunEvent;
import ru.vyarus.guicey.gsp.app.GlobalConfig;
import ru.vyarus.guicey.gsp.app.ServerPagesApp;
import ru.vyarus.guicey.gsp.app.ServerPagesAppBundle;
import ru.vyarus.guicey.gsp.app.asset.freemarker.FreemarkerTemplateLoader;
import ru.vyarus.guicey.gsp.app.ext.ServerPagesAppExtensionBundle;
import ru.vyarus.guicey.gsp.app.rest.log.RestPathsAnalyzer;
import ru.vyarus.guicey.gsp.app.rest.support.DirectTemplateExceptionMapper;
import ru.vyarus.guicey.gsp.app.rest.support.TemplateAnnotationFilter;
import ru.vyarus.guicey.gsp.app.rest.support.TemplateErrorResponseFilter;
import ru.vyarus.guicey.gsp.app.rest.support.TemplateExceptionListener;
import ru.vyarus.guicey.gsp.info.GspInfoModule;
import ru.vyarus.guicey.gsp.views.ConfiguredViewBundle;
import ru.vyarus.guicey.gsp.views.ViewRendererConfigurationModifier;

public class ServerPagesBundle
extends UniqueGuiceyBundle {
    public static final String FILE_REQUEST_PATTERN = "(?:^|/)([^/]+\\.(?:[a-zA-Z\\d]+))(?:\\?.+)?$";
    private static final Logger LOGGER = LoggerFactory.getLogger(ServerPagesBundle.class);
    private final GlobalConfig config;

    public ServerPagesBundle(GlobalConfig config) {
        this.config = config;
    }

    public static ViewsBuilder builder() {
        return new ViewsBuilder();
    }

    public static ServerPagesAppBundle.AppBuilder app(String name, String assetsPath, String uriPath) {
        return ServerPagesBundle.app(name, assetsPath, uriPath, null);
    }

    public static ServerPagesAppBundle.AppBuilder app(String name, String assetsPath, String uriPath, ClassLoader loader) {
        LOGGER.debug("Registering server pages application {} on path {} with resources in {}", new Object[]{name, uriPath, assetsPath});
        return new ServerPagesAppBundle.AppBuilder(true, name, assetsPath, uriPath, loader);
    }

    public static ServerPagesAppBundle.AppBuilder adminApp(String name, String assetsPath, String uriPath) {
        return ServerPagesBundle.adminApp(name, assetsPath, uriPath, null);
    }

    public static ServerPagesAppBundle.AppBuilder adminApp(String name, String assetsPath, String uriPath, ClassLoader loader) {
        LOGGER.debug("Registering admin server pages application {} on path {} with resources in {}", new Object[]{name, uriPath, assetsPath});
        return new ServerPagesAppBundle.AppBuilder(false, name, assetsPath, uriPath, loader);
    }

    public static ServerPagesAppExtensionBundle.AppExtensionBuilder extendApp(String name) {
        return ServerPagesBundle.extendApp(name, null);
    }

    public static ServerPagesAppExtensionBundle.AppExtensionBuilder extendApp(String name, ClassLoader loader) {
        return new ServerPagesAppExtensionBundle.AppExtensionBuilder(name, loader);
    }

    public List<ViewRenderer> getRenderers() {
        return ImmutableList.copyOf(this.config.getRenderers());
    }

    public Map<String, Map<String, String>> getViewsConfig() {
        return ImmutableMap.copyOf((Map)((Map)Preconditions.checkNotNull(this.config.getViewsConfig(), (Object)"Views configuration is not created yet")));
    }

    public void initialize(GuiceyBootstrap bootstrap) {
        this.loadRenderers();
        bootstrap.shareState(ServerPagesBundle.class, (Object)this.config).modules(new Module[]{new GspInfoModule()}).dropwizardBundles(new ConfiguredBundle[]{new ConfiguredViewBundle(this.config)}).extensions(new Class[]{TemplateAnnotationFilter.class, TemplateErrorResponseFilter.class, TemplateExceptionListener.class, DirectTemplateExceptionMapper.class});
    }

    public void run(final GuiceyEnvironment environment) {
        environment.listen(new GuiceyLifecycleListener[]{new GuiceyLifecycleAdapter(){

            protected void applicationRun(ApplicationRunEvent event) {
                ServerPagesBundle.this.config.applyDelayedExtensions(environment);
                for (ServerPagesApp app : ServerPagesBundle.this.config.getApps()) {
                    app.install(environment.environment(), ServerPagesBundle.this.config);
                }
            }
        }});
        environment.listenServer(it -> {
            Environment env = environment.environment();
            String contextPath = env.getJerseyServletContainer().getServletConfig().getServletContext().getContextPath();
            String restMapping = PathUtils.trailingSlash((String)PathUtils.trimStars((String)env.jersey().getUrlPattern()));
            RestPathsAnalyzer analyzer = RestPathsAnalyzer.build(env.jersey().getResourceConfig());
            for (ServerPagesApp app : this.config.getApps()) {
                app.jerseyStarted(contextPath, restMapping, analyzer);
            }
        });
    }

    private void loadRenderers() {
        ServiceLoader<ViewRenderer> renderers = ServiceLoader.load(ViewRenderer.class);
        renderers.forEach(xva$0 -> this.config.addRenderers((ViewRenderer)xva$0));
        Preconditions.checkState((!this.config.getRenderers().isEmpty() ? 1 : 0) != 0, (Object)"No template engines found (dropwizard views renderer)");
        StringBuilder res = new StringBuilder("Available dropwizard-views renderers:").append(Reporter.NEWLINE).append(Reporter.NEWLINE);
        for (ViewRenderer renderer : this.config.getRenderers()) {
            res.append("    ").append(String.format("%-15s (%s)", renderer.getConfigurationKey(), renderer.getClass().getName())).append(Reporter.NEWLINE);
        }
        LOGGER.info(res.toString());
    }

    public static class ViewsBuilder {
        private final GlobalConfig config = new GlobalConfig();

        public ViewsBuilder addViewRenderers(ViewRenderer ... renderers) {
            this.config.addRenderers(renderers);
            return this;
        }

        public <T extends Configuration> ViewsBuilder viewsConfiguration(ViewConfigurable<T> configurable) {
            this.config.setConfigurable(configurable);
            return this;
        }

        public ViewsBuilder viewsConfigurationModifier(String name, ViewRendererConfigurationModifier modifier) {
            this.config.addConfigModifier(name, modifier);
            return this;
        }

        public ViewsBuilder printViewsConfiguration() {
            this.config.printConfiguration();
            return this;
        }

        public ViewsBuilder enableFreemarkerCustomClassLoadersSupport() {
            return this.viewsConfigurationModifier("freemarker", config -> config.put("template_loader", FreemarkerTemplateLoader.class.getName()));
        }

        public ServerPagesBundle build() {
            return new ServerPagesBundle(this.config);
        }
    }
}

