/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.guicey.gsp.app.ext;

import com.google.common.base.Preconditions;
import ru.vyarus.dropwizard.guice.module.installer.bundle.GuiceyEnvironment;
import ru.vyarus.guicey.gsp.app.asset.AssetSources;
import ru.vyarus.guicey.gsp.app.ext.DelayedConfigurationCallback;
import ru.vyarus.guicey.gsp.app.rest.mapping.ViewRestSources;

public class ExtendedConfiguration {
    private final String name;
    private final AssetSources assets = new AssetSources();
    private final ViewRestSources views = new ViewRestSources();
    private DelayedConfigurationCallback delayedConfigCallback;

    public ExtendedConfiguration(String name) {
        this.name = name;
    }

    public void setDelayedCallback(DelayedConfigurationCallback callback) {
        Preconditions.checkArgument((this.delayedConfigCallback == null ? 1 : 0) != 0, (Object)"Only one delayed configuration could be registered");
        this.delayedConfigCallback = callback;
    }

    public void configure(GuiceyEnvironment environment) {
        if (this.delayedConfigCallback != null) {
            this.delayedConfigCallback.configure(environment, this.assets, this.views);
        }
    }

    public String getName() {
        return this.name;
    }

    public AssetSources getAssets() {
        return this.assets;
    }

    public ViewRestSources getViews() {
        return this.views;
    }
}

