/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.guicey.gsp.app.filter;

import com.google.common.base.Preconditions;
import io.dropwizard.views.common.View;
import io.dropwizard.views.common.ViewRenderer;
import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.ws.rs.core.Response;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.vyarus.dropwizard.guice.module.installer.util.PathUtils;
import ru.vyarus.guicey.gsp.app.filter.AssetError;
import ru.vyarus.guicey.gsp.app.filter.redirect.SpaSupport;
import ru.vyarus.guicey.gsp.app.filter.redirect.TemplateRedirect;

public class ServerPagesFilter
implements Filter {
    private final Logger logger = LoggerFactory.getLogger(ServerPagesFilter.class);
    private final String uriPath;
    private final Pattern filePattern;
    private final String index;
    private final TemplateRedirect redirect;
    private final SpaSupport spa;
    private final Iterable<ViewRenderer> renderers;

    public ServerPagesFilter(String uriPath, String filePattern, String index, TemplateRedirect redirect, SpaSupport spa, Iterable<ViewRenderer> renderers) {
        this.uriPath = uriPath;
        this.filePattern = Pattern.compile(filePattern);
        this.index = index;
        this.redirect = redirect;
        this.spa = spa;
        this.renderers = renderers;
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain chain) throws IOException, ServletException {
        ViewRenderer directTemplate;
        HttpServletRequest req = (HttpServletRequest)servletRequest;
        HttpServletResponse resp = (HttpServletResponse)servletResponse;
        String requestURI = req.getRequestURI();
        this.logger.debug("[GSP IN] Processing request '{}'", (Object)requestURI);
        this.spa.markPossibleSpaRoute(req, resp);
        String pathFile = this.findFileInPath(req);
        ViewRenderer viewRenderer = directTemplate = pathFile != null ? this.findRenderer(pathFile) : null;
        if (pathFile != null && directTemplate == null) {
            this.logger.debug("Serving asset: {}", (Object)requestURI);
            this.serveAsset(req, resp, chain);
            return;
        }
        String page = PathUtils.trailingSlash((String)requestURI).equals(this.uriPath) ? "" : requestURI.substring(this.uriPath.length());
        if (page.isEmpty()) {
            page = this.index;
        }
        this.redirect.redirect(req, resp, page, directTemplate);
    }

    public void destroy() {
    }

    private String findFileInPath(HttpServletRequest req) {
        if (this.isRoot(req)) {
            return this.filePattern.matcher(this.index).find() ? this.index : null;
        }
        Matcher matcher = this.filePattern.matcher(req.getRequestURI());
        boolean detected = matcher.find();
        Preconditions.checkState((!detected || matcher.groupCount() > 0 ? 1 : 0) != 0, (String)"File detection pattern %s did not contain file capture group (1)", (Object)this.filePattern.pattern());
        return detected ? matcher.group(1) : null;
    }

    private boolean isRoot(HttpServletRequest req) {
        String uri = req.getRequestURI();
        String path = PathUtils.trailingSlash((String)uri);
        return path.equals(this.uriPath);
    }

    private ViewRenderer findRenderer(String file) {
        DummyView view = new DummyView(file);
        for (ViewRenderer renderer : this.renderers) {
            if (!renderer.isRenderable((View)view)) continue;
            this.logger.debug("Possible direct {} template {} request", (Object)renderer.getConfigurationKey(), (Object)file);
            return renderer;
        }
        return null;
    }

    private void serveAsset(HttpServletRequest req, HttpServletResponse resp, FilterChain chain) throws IOException, ServletException {
        chain.doFilter((ServletRequest)req, (ServletResponse)resp);
        this.handleError(req, resp);
    }

    private void handleError(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        int error = resp.getStatus();
        if (error != Response.Status.OK.getStatusCode()) {
            this.logger.debug("Possible asset '{}' error detected: {}", (Object)req.getRequestURI(), (Object)error);
            if (error <= 400 || !this.redirect.getErrorRedirect().redirect(req, resp, new AssetError(req, error))) {
                this.logger.debug("Sending direct response code {} for asset '{}'", (Object)error, (Object)req.getRequestURI());
            }
        }
    }

    private static class DummyView
    extends View {
        DummyView(String templateName) {
            super(templateName);
        }
    }
}

