/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.guicey.gsp.app.rest.support;

import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import jakarta.ws.rs.container.ContainerRequestContext;
import jakarta.ws.rs.container.ContainerRequestFilter;
import jakarta.ws.rs.container.ResourceInfo;
import jakarta.ws.rs.ext.Provider;
import java.io.IOException;
import java.lang.reflect.Method;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.vyarus.guicey.gsp.views.template.ManualErrorHandling;
import ru.vyarus.guicey.gsp.views.template.Template;
import ru.vyarus.guicey.gsp.views.template.TemplateContext;

@Template
@Singleton
@Provider
public class TemplateAnnotationFilter
implements ContainerRequestFilter {
    private final Logger logger = LoggerFactory.getLogger(TemplateAnnotationFilter.class);
    @Inject
    private jakarta.inject.Provider<ResourceInfo> info;

    public void filter(ContainerRequestContext requestContext) throws IOException {
        ResourceInfo resourceInfo = (ResourceInfo)this.info.get();
        Class resourceClass = resourceInfo.getResourceClass();
        Template template = resourceClass.getAnnotation(Template.class);
        if (template != null) {
            TemplateContext context = TemplateContext.getInstance();
            context.setResourceClass(resourceClass);
            String tpl = template.value();
            if (!tpl.isEmpty()) {
                context.setAnnotationTemplate(tpl);
                this.logger.debug("View template declared in annotation: {} ({})", (Object)tpl, (Object)resourceClass.getSimpleName());
            }
            Method method = resourceInfo.getResourceMethod();
            context.setManualErrorHandling(resourceClass.isAnnotationPresent(ManualErrorHandling.class) || method != null && method.isAnnotationPresent(ManualErrorHandling.class));
        }
    }
}

