/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.guicey.gsp.app;

import com.google.common.base.Preconditions;
import io.dropwizard.views.common.ViewRenderer;
import java.util.ArrayList;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.vyarus.dropwizard.guice.module.installer.bundle.GuiceyBootstrap;
import ru.vyarus.dropwizard.guice.module.installer.bundle.GuiceyBundle;
import ru.vyarus.dropwizard.guice.module.installer.bundle.GuiceyEnvironment;
import ru.vyarus.dropwizard.guice.module.installer.util.PathUtils;
import ru.vyarus.guicey.gsp.ServerPagesBundle;
import ru.vyarus.guicey.gsp.app.ServerPagesApp;
import ru.vyarus.guicey.gsp.app.ServerPagesGlobalState;
import ru.vyarus.guicey.gsp.views.ViewRendererConfigurationModifier;

public class ServerPagesAppBundle
implements GuiceyBundle {
    private static final Logger LOGGER = LoggerFactory.getLogger(ServerPagesAppBundle.class);
    private static final String COMMA = ", ";
    private final ServerPagesApp app;
    private ServerPagesGlobalState config;

    public ServerPagesAppBundle(ServerPagesApp app) {
        this.app = app;
    }

    public void initialize(GuiceyBootstrap bootstrap) {
        this.config = (ServerPagesGlobalState)bootstrap.sharedStateOrFail(ServerPagesGlobalState.class, "Either server pages support bundle was not installed (use %s.builder() to create bundle)  or it was installed after '%s' application bundle", new Object[]{ServerPagesBundle.class.getSimpleName(), this.app.name});
        this.config.register(this.app);
    }

    public void run(GuiceyEnvironment environment) {
        this.validateRequirements();
    }

    private void validateRequirements() {
        if (this.app.requiredRenderers == null) {
            return;
        }
        ArrayList<String> available = new ArrayList<String>();
        ArrayList<String> required = new ArrayList<String>(this.app.requiredRenderers);
        for (ViewRenderer renderer : this.config.getRenderers()) {
            String key = renderer.getConfigurationKey();
            available.add(key);
            required.remove(key);
        }
        Preconditions.checkState((boolean)required.isEmpty(), (String)"Required template engines are missed for server pages application '%s': %s (available engines: %s)", (Object)this.app.name, (Object)String.join((CharSequence)COMMA, required), (Object)String.join((CharSequence)COMMA, available));
    }

    public static class AppBuilder {
        private final ServerPagesApp app = new ServerPagesApp();
        private final ClassLoader loader;

        public AppBuilder(boolean mainContext, String name, String path, String uri, ClassLoader loader) {
            this.loader = loader;
            this.app.mainContext = mainContext;
            this.app.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Name is required");
            this.app.uriPath = PathUtils.leadingSlash((String)PathUtils.trailingSlash((String)uri));
            this.app.mainAssetsPath = PathUtils.normalizeClasspathPath((String)path);
            Preconditions.checkArgument((!"/".equals(this.app.mainAssetsPath) ? 1 : 0) != 0, (String)"%s is the classpath root", (Object)this.app.mainAssetsPath);
            this.app.assetLocations.attach(this.app.mainAssetsPath, loader);
        }

        public AppBuilder mapViews(String prefix) {
            this.app.viewPrefixes.map(prefix);
            return this;
        }

        public AppBuilder mapViews(String subUrl, String prefix) {
            this.app.viewPrefixes.map(subUrl, prefix);
            return this;
        }

        public AppBuilder requireRenderers(String ... names) {
            this.app.requiredRenderers = Arrays.asList(names);
            return this;
        }

        public AppBuilder spaRouting() {
            return this.spaRouting(null);
        }

        public AppBuilder spaRouting(String noRedirectRegex) {
            if (noRedirectRegex != null) {
                this.app.spaNoRedirectRegex = noRedirectRegex;
            }
            this.app.spaSupport = true;
            return this;
        }

        public AppBuilder indexPage(String name) {
            this.app.indexFile = name;
            return this;
        }

        public AppBuilder errorPage(String path) {
            return this.errorPage(-1, path);
        }

        public AppBuilder errorPage(int code, String path) {
            Preconditions.checkArgument((code >= 400 || code == -1 ? 1 : 0) != 0, (Object)"Only error codes (4xx, 5xx) allowed for mapping");
            this.app.errorPages.put(code, path);
            return this;
        }

        public AppBuilder attachAssets(String path) {
            this.app.assetLocations.attach(path, this.loader);
            return this;
        }

        public AppBuilder attachAssets(String subUrl, String path) {
            this.app.assetLocations.attach(subUrl, path, this.loader);
            return this;
        }

        public AppBuilder attachWebjars() {
            return this.attachAssets("META-INF/resources/webjars/");
        }

        public AppBuilder filePattern(String regex) {
            this.app.fileRequestPattern = (String)Preconditions.checkNotNull((Object)regex, (Object)"Regex can't be null");
            return this;
        }

        public AppBuilder viewsConfigurationModifier(String name, ViewRendererConfigurationModifier modifier) {
            LOGGER.info("Server pages application '{}' modifies '{}' section of views configuration", (Object)this.app.name, (Object)name);
            this.app.viewsConfigModifiers.put(name, modifier);
            return this;
        }

        public ServerPagesAppBundle build() {
            return new ServerPagesAppBundle(this.app);
        }
    }
}

