/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.guicey.gsp.app.rest.support;

import jakarta.inject.Singleton;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.ext.Provider;
import org.glassfish.jersey.server.monitoring.ApplicationEvent;
import org.glassfish.jersey.server.monitoring.ApplicationEventListener;
import org.glassfish.jersey.server.monitoring.RequestEvent;
import org.glassfish.jersey.server.monitoring.RequestEventListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.vyarus.guicey.gsp.app.filter.redirect.TemplateRedirect;
import ru.vyarus.guicey.gsp.app.rest.support.DirectTemplateExceptionMapper;
import ru.vyarus.guicey.gsp.views.template.TemplateContext;

@Provider
@Singleton
public class TemplateExceptionListener
implements ApplicationEventListener {
    public static final String QUOTE = "'";
    private final RequestListener listener = new RequestListener();

    public void onEvent(ApplicationEvent event) {
    }

    public RequestEventListener onRequest(RequestEvent requestEvent) {
        return TemplateRedirect.templateContext() != null ? this.listener : null;
    }

    private static final class RequestListener
    implements RequestEventListener {
        private final Logger logger = LoggerFactory.getLogger(TemplateExceptionListener.class);

        private RequestListener() {
        }

        public void onEvent(RequestEvent event) {
            if (event.getType() == RequestEvent.Type.ON_EXCEPTION && !DirectTemplateExceptionMapper.canHandle(event)) {
                Throwable exception = event.getException();
                if (!(exception instanceof WebApplicationException)) {
                    this.logger.error("Exception processing view rest path '" + event.getUriInfo().getPath() + TemplateExceptionListener.QUOTE, exception);
                } else if (this.logger.isDebugEnabled()) {
                    this.logger.debug("View rest processing exception detected for path '" + event.getUriInfo().getPath() + TemplateExceptionListener.QUOTE, exception);
                }
                TemplateContext.getInstance().redirectError(exception);
            }
        }
    }
}

