/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.guicey.gsp.app;

import com.google.common.base.Joiner;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSortedMap;
import com.google.common.collect.Multimap;
import io.dropwizard.core.setup.Environment;
import io.dropwizard.jetty.setup.ServletEnvironment;
import io.dropwizard.views.common.ViewRenderer;
import jakarta.servlet.DispatcherType;
import jakarta.servlet.Filter;
import jakarta.servlet.Servlet;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.commons.lang3.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.vyarus.dropwizard.guice.module.installer.util.PathUtils;
import ru.vyarus.guicey.gsp.app.AppReportBuilder;
import ru.vyarus.guicey.gsp.app.ServerPagesGlobalState;
import ru.vyarus.guicey.gsp.app.asset.AssetLookup;
import ru.vyarus.guicey.gsp.app.asset.AssetSources;
import ru.vyarus.guicey.gsp.app.asset.servlet.AssetResolutionServlet;
import ru.vyarus.guicey.gsp.app.filter.ServerPagesFilter;
import ru.vyarus.guicey.gsp.app.filter.redirect.ErrorRedirect;
import ru.vyarus.guicey.gsp.app.filter.redirect.SpaSupport;
import ru.vyarus.guicey.gsp.app.filter.redirect.TemplateRedirect;
import ru.vyarus.guicey.gsp.app.rest.log.HiddenViewPath;
import ru.vyarus.guicey.gsp.app.rest.log.MappedViewPath;
import ru.vyarus.guicey.gsp.app.rest.log.RestPathsAnalyzer;
import ru.vyarus.guicey.gsp.app.rest.log.ViewPath;
import ru.vyarus.guicey.gsp.app.rest.mapping.ViewRestLookup;
import ru.vyarus.guicey.gsp.app.rest.mapping.ViewRestSources;
import ru.vyarus.guicey.gsp.info.model.GspApp;
import ru.vyarus.guicey.gsp.views.ViewRendererConfigurationModifier;

public class ServerPagesApp {
    protected String name;
    protected boolean mainContext;
    protected String mainAssetsPath;
    protected String uriPath;
    protected String indexFile = "";
    protected String fileRequestPattern = "(?:^|/)([^/]+\\.(?:[a-zA-Z\\d]+))(?:\\?.+)?$";
    protected List<String> requiredRenderers;
    protected boolean spaSupport;
    protected String spaNoRedirectRegex = "\\.(html|css|js|png|jpg|jpeg|gif|ico|xml|rss|txt|eot|svg|ttf|woff|woff2|cur)(\\?((r|v|rel|rev)=[\\-\\.\\w]*)?)?$";
    protected final Map<String, ViewRendererConfigurationModifier> viewsConfigModifiers = new HashMap<String, ViewRendererConfigurationModifier>();
    protected final AssetSources assetLocations = new AssetSources();
    protected final ViewRestSources viewPrefixes = new ViewRestSources();
    protected final Map<Integer, String> errorPages = new TreeMap<Integer, String>();
    protected String fullUriPath;
    protected TemplateRedirect templateRedirect;
    protected AssetLookup assets;
    protected ViewRestLookup views;
    protected List<MappedViewPath> viewPaths;
    protected List<HiddenViewPath> hiddenViewPaths;
    private boolean started;
    private final Logger logger = LoggerFactory.getLogger(ServerPagesApp.class);

    public String getName() {
        return this.name;
    }

    public void install(Environment environment, ServerPagesGlobalState config) {
        ServletEnvironment context = this.mainContext ? environment.servlets() : environment.admin();
        String contextMapping = this.mainContext ? environment.getApplicationContext().getContextPath() : environment.getAdminContext().getContextPath();
        this.fullUriPath = PathUtils.path((String[])new String[]{contextMapping, this.uriPath});
        this.assets = this.collectAssets(config);
        this.installAssetsServlet(context);
        this.views = this.collectViews(config);
        SpaSupport spa = new SpaSupport(this.spaSupport, this.fullUriPath, this.uriPath, this.spaNoRedirectRegex);
        this.templateRedirect = new TemplateRedirect(environment.getJerseyServletContainer(), this.name, this.fullUriPath, this.views, this.assets, new ErrorRedirect(this.uriPath, this.errorPages, spa));
        this.installTemplatesSupportFilter(context, this.templateRedirect, spa, config.getRenderers());
    }

    public void jerseyStarted(String restContext, String restMapping, RestPathsAnalyzer analyzer) {
        this.templateRedirect.setRootPath(restContext, restMapping);
        this.analyzePaths(analyzer);
        this.logger.info(AppReportBuilder.build(this));
        this.started = true;
    }

    public GspApp getInfo(ServerPagesGlobalState config) {
        GspApp res = new GspApp();
        res.setName(this.name);
        res.setMainContext(this.mainContext);
        res.setMappingUrl(this.uriPath);
        res.setRootUrl(this.fullUriPath);
        res.setRequiredRenderers(this.requiredRenderers == null ? Collections.emptyList() : this.requiredRenderers);
        res.setMainAssetsLocation(this.mainAssetsPath);
        res.setAssets(this.assets.getLocations());
        AssetSources assetExtensions = config.getAssetExtensions(this.name);
        res.setAssetExtensions(assetExtensions == null ? HashMultimap.create() : assetExtensions.getLocations());
        res.setViews(this.views.getPrefixes());
        ViewRestSources viewExtensions = config.getViewExtensions(this.name);
        res.setViewExtensions(viewExtensions == null ? Collections.emptyMap() : viewExtensions.getPrefixes());
        res.setRestRootUrl(this.templateRedirect.getRootPath());
        res.setIndexFile(this.indexFile);
        res.setFilesRegex(this.fileRequestPattern);
        res.setHasDefaultFilesRegex("(?:^|/)([^/]+\\.(?:[a-zA-Z\\d]+))(?:\\?.+)?$".equals(this.fileRequestPattern));
        res.setSpa(this.spaSupport);
        res.setSpaRegex(this.spaNoRedirectRegex);
        res.setHasDefaultSpaRegex("\\.(html|css|js|png|jpg|jpeg|gif|ico|xml|rss|txt|eot|svg|ttf|woff|woff2|cur)(\\?((r|v|rel|rev)=[\\-\\.\\w]*)?)?$".equals(this.spaNoRedirectRegex));
        res.setErrorPages(this.errorPages);
        res.setViewPaths((List<MappedViewPath>)ImmutableList.copyOf(this.viewPaths));
        res.setHiddenViewPaths((List<HiddenViewPath>)(this.hiddenViewPaths.isEmpty() ? Collections.emptyList() : ImmutableList.copyOf(this.hiddenViewPaths)));
        return res;
    }

    protected boolean isStarted() {
        return this.started;
    }

    private AssetLookup collectAssets(ServerPagesGlobalState config) {
        AssetSources ext = config.getAssetExtensions(this.name);
        if (ext != null) {
            this.assetLocations.merge(ext);
        }
        ImmutableMultimap.Builder urlsBuilder = ImmutableMultimap.builder().orderKeysBy(Comparator.comparing(String::length).reversed());
        Multimap<String, String> src = this.assetLocations.getLocations();
        for (String key : src.keySet()) {
            Object[] values = src.get((Object)key).toArray(new String[0]);
            ArrayUtils.reverse((Object[])values);
            urlsBuilder.putAll((Object)key, values);
        }
        ImmutableMultimap.Builder loadersBuilder = ImmutableMultimap.builder().orderKeysBy(Comparator.comparing(String::length).reversed());
        Multimap<String, ClassLoader> loaders = this.assetLocations.getLoaders();
        for (String key : loaders.keySet()) {
            Object[] values = loaders.get((Object)key).toArray(new ClassLoader[0]);
            ArrayUtils.reverse((Object[])values);
            loadersBuilder.putAll((Object)key, values);
        }
        return new AssetLookup(this.mainAssetsPath, (Multimap<String, String>)urlsBuilder.build(), (Multimap<String, ClassLoader>)loadersBuilder.build());
    }

    private ViewRestLookup collectViews(ServerPagesGlobalState config) {
        ViewRestSources ext = config.getViewExtensions(this.name);
        if (ext != null) {
            this.viewPrefixes.merge(ext);
        }
        if (!this.viewPrefixes.getPrefixes().containsKey("")) {
            this.viewPrefixes.map(this.name);
        }
        ImmutableSortedMap.Builder builder = ImmutableSortedMap.orderedBy(Comparator.comparing(String::length).reversed()).putAll(this.viewPrefixes.getPrefixes());
        return new ViewRestLookup((Map<String, String>)builder.build());
    }

    private void installAssetsServlet(ServletEnvironment context) {
        Set clash = context.addServlet(this.name, (Servlet)new AssetResolutionServlet(this.assets, this.uriPath, this.indexFile, StandardCharsets.UTF_8)).addMapping(new String[]{this.uriPath + "*"});
        if (clash != null && !clash.isEmpty()) {
            throw new IllegalStateException(String.format("Assets servlet %s registration clash with already installed servlets on paths: %s", this.name, Joiner.on((char)',').join((Iterable)clash)));
        }
    }

    private void installTemplatesSupportFilter(ServletEnvironment context, TemplateRedirect templateRedirect, SpaSupport spa, List<ViewRenderer> renderers) {
        EnumSet<DispatcherType> types = EnumSet.of(DispatcherType.REQUEST, DispatcherType.FORWARD);
        context.addFilter(this.name + "Templates", (Filter)new ServerPagesFilter(this.fullUriPath, this.fileRequestPattern, this.indexFile, templateRedirect, spa, renderers)).addMappingForServletNames(types, false, new String[]{this.name});
    }

    private void analyzePaths(RestPathsAnalyzer analyzer) {
        this.viewPaths = new ArrayList<MappedViewPath>();
        this.hiddenViewPaths = new ArrayList<HiddenViewPath>();
        ArrayList<String> overrides = new ArrayList<String>();
        for (Map.Entry<String, String> entry : this.views.getPrefixes().entrySet()) {
            String sub = entry.getKey();
            String prefix = PathUtils.leadingSlash((String)entry.getValue());
            for (ViewPath handle : analyzer.select(prefix)) {
                String relativeUrl = handle.getUrl().substring(prefix.length());
                boolean hidden = false;
                for (String overrideSub : overrides) {
                    if (!relativeUrl.startsWith(overrideSub)) continue;
                    this.hiddenViewPaths.add(new HiddenViewPath(handle, sub, prefix, overrideSub));
                    hidden = true;
                    break;
                }
                if (hidden) continue;
                this.viewPaths.add(new MappedViewPath(handle, sub, prefix));
            }
            overrides.add(sub);
        }
        this.hiddenViewPaths.removeAll(this.viewPaths);
    }
}

