/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.guicey.gsp.app.filter.redirect;

import com.google.common.base.Preconditions;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.ws.rs.WebApplicationException;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.vyarus.dropwizard.guice.module.installer.util.PathUtils;
import ru.vyarus.guicey.gsp.app.filter.AssetError;
import ru.vyarus.guicey.gsp.app.filter.redirect.SpaSupport;
import ru.vyarus.guicey.gsp.app.rest.support.TemplateRestCodeError;
import ru.vyarus.guicey.spa.filter.SpaUtils;

public class ErrorRedirect {
    public static final int DEFAULT_ERROR_PAGE = -1;
    public static final int CODE_400 = 400;
    private static final ThreadLocal<ErrorContext> CONTEXT_ERROR = new ThreadLocal();
    private final Logger logger = LoggerFactory.getLogger(ErrorRedirect.class);
    private final Map<Integer, String> errorPages;
    private final SpaSupport spa;

    public ErrorRedirect(String appMapping, Map<Integer, String> pages, SpaSupport spa) {
        this.errorPages = new HashMap<Integer, String>(pages);
        this.spa = spa;
        for (int code : pages.keySet()) {
            this.errorPages.put(code, PathUtils.path((String[])new String[]{appMapping, this.errorPages.get(code)}));
        }
    }

    public boolean redirect(HttpServletRequest request, HttpServletResponse response, WebApplicationException exception) {
        return this.spa.redirect(request, response, exception.getResponse().getStatus()) || SpaUtils.isHtmlRequest((HttpServletRequest)request) && this.doRedirect(request, response, exception);
    }

    public static WebApplicationException getContextError() {
        return ErrorRedirect.getContext().exception;
    }

    public static String getContextErrorOriginalUrl() {
        return ErrorRedirect.getContext().originalUrl;
    }

    public static boolean hasContextError() {
        return CONTEXT_ERROR.get() != null;
    }

    private String selectErrorPage(WebApplicationException exception) {
        int status = exception.getResponse().getStatus();
        if (status >= 400) {
            String res = this.errorPages.get(status);
            return res == null ? this.errorPages.get(-1) : res;
        }
        return null;
    }

    private boolean doRedirect(HttpServletRequest request, HttpServletResponse response, WebApplicationException exception) {
        return this.handleErrorRenderingError(exception, request, response) || CONTEXT_ERROR.get() == null && this.handleErrorRedirect(exception, request, response);
    }

    private boolean handleErrorRenderingError(WebApplicationException exception, HttpServletRequest request, HttpServletResponse response) {
        ErrorContext context = CONTEXT_ERROR.get();
        if (context != null && !context.processed) {
            this.logger.debug("Error page '" + request.getRequestURI() + "' processing error", (Throwable)exception);
            this.onUnexpectedError(request.getRequestURI(), context.originalUrl, context.exception.getResponse().getStatus(), (Exception)context.exception, response);
            context.processed = true;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean handleErrorRedirect(WebApplicationException exception, HttpServletRequest request, HttpServletResponse response) {
        String path = this.selectErrorPage(exception);
        if (path != null && !response.isCommitted()) {
            this.logger.debug("Redirecting failed '{}' request to '{}' error page", (Object)request.getRequestURI(), (Object)path);
            ErrorContext context = new ErrorContext(exception, request);
            CONTEXT_ERROR.set(context);
            try {
                response.reset();
                request.getRequestDispatcher(path).forward((ServletRequest)request, (ServletResponse)response);
                if (!context.processed) {
                    this.logger.info("Serving error page '{}' instead of '{}' response error {}", new Object[]{path, request.getRequestURL(), exception.getResponse().getStatus()});
                }
            }
            catch (Exception ex) {
                this.onUnexpectedError(path, request.getRequestURI(), exception.getResponse().getStatus(), (Exception)exception, response);
            }
            finally {
                CONTEXT_ERROR.remove();
            }
            return true;
        }
        return false;
    }

    private void onUnexpectedError(String errorPage, String originalPage, int code, Exception originalException, HttpServletResponse response) {
        String ex = originalException instanceof AssetError ? "asset error" : (originalException instanceof TemplateRestCodeError ? "direct rest status" : "rest exception");
        this.logger.error(String.format("Failed to serve error page '%s' for request '%s' instead of %s. Error code %s will be returned instead of error page.", errorPage, originalPage, ex, code));
        try {
            response.setStatus(ErrorRedirect.CONTEXT_ERROR.get().exception.getResponse().getStatus());
            response.flushBuffer();
        }
        catch (IOException e) {
            this.logger.error("Error processing response", (Throwable)e);
        }
    }

    private static ErrorContext getContext() {
        return (ErrorContext)Preconditions.checkNotNull((Object)CONTEXT_ERROR.get(), (Object)"No context error");
    }

    private static class ErrorContext {
        protected final WebApplicationException exception;
        protected final String originalUrl;
        protected boolean processed;

        protected ErrorContext(WebApplicationException exception, HttpServletRequest originalRequest) {
            this.exception = exception;
            this.originalUrl = originalRequest.getRequestURI();
        }
    }
}

