/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.guicey.gsp.views.template;

import com.google.common.base.CharMatcher;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import io.dropwizard.views.common.ViewRenderer;
import jakarta.annotation.Nullable;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.ws.rs.WebApplicationException;
import java.net.URL;
import org.glassfish.jersey.server.internal.process.MappableException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.vyarus.dropwizard.guice.module.installer.util.PathUtils;
import ru.vyarus.guicey.gsp.app.asset.AssetLookup;
import ru.vyarus.guicey.gsp.app.filter.redirect.ErrorRedirect;
import ru.vyarus.guicey.gsp.app.filter.redirect.TemplateRedirect;
import ru.vyarus.guicey.gsp.app.util.ResourceLookup;

public class TemplateContext {
    private final Logger logger = LoggerFactory.getLogger(TemplateContext.class);
    private final String appName;
    private final String rootUrl;
    private final String restSubContext;
    private final String restPrefix;
    private final ViewRenderer directTemplateRenderer;
    private final AssetLookup assets;
    private final ErrorRedirect errorRedirect;
    private final HttpServletRequest request;
    private final HttpServletResponse response;
    private Class resourceClass;
    private String annotationTemplate;
    private boolean manualErrorHandling;

    public TemplateContext(String appName, String rootUrl, String restSubContext, String restPrefix, ViewRenderer directTemplateRenderer, AssetLookup assets, ErrorRedirect errorRedirect, HttpServletRequest request, HttpServletResponse response) {
        this.appName = appName;
        this.rootUrl = rootUrl;
        this.restSubContext = restSubContext;
        this.restPrefix = restPrefix;
        this.directTemplateRenderer = directTemplateRenderer;
        this.assets = assets;
        this.errorRedirect = errorRedirect;
        this.request = request;
        this.response = response;
    }

    public static TemplateContext getInstance() {
        return (TemplateContext)Preconditions.checkNotNull((Object)TemplateRedirect.templateContext(), (Object)"No template context found for current thread");
    }

    public String getAppName() {
        return this.appName;
    }

    public String getRootUrl() {
        return this.rootUrl;
    }

    public String getRestSubContext() {
        return PathUtils.leadingSlash((String)this.restSubContext);
    }

    public String getRestPrefix() {
        return PathUtils.leadingSlash((String)this.restPrefix);
    }

    public boolean isDirectTemplate() {
        return this.directTemplateRenderer != null;
    }

    public ViewRenderer getDirectTemplateRenderer() {
        return this.directTemplateRenderer;
    }

    public String getUrl() {
        return this.getRequest().getRequestURI();
    }

    public HttpServletRequest getRequest() {
        return this.request;
    }

    public HttpServletResponse getResponse() {
        return this.response;
    }

    public void setResourceClass(Class base) {
        this.resourceClass = base;
    }

    public void setAnnotationTemplate(String template) {
        this.annotationTemplate = template;
    }

    public void setManualErrorHandling(boolean manualErrors) {
        this.manualErrorHandling = manualErrors;
    }

    public String lookupTemplatePath(@Nullable String template) {
        String classRelativePath;
        String path = Strings.emptyToNull((String)template);
        if (path == null) {
            path = this.annotationTemplate;
        }
        Preconditions.checkNotNull((Object)path, (Object)"Template name not specified neither directly in model nor in @Template annotation");
        if (!path.startsWith("/") && this.resourceClass != null && this.assets.load(classRelativePath = PathUtils.path((String[])new String[]{PathUtils.packagePath((Class)this.resourceClass), CharMatcher.is((char)'/').trimLeadingFrom((CharSequence)path)})) != null) {
            this.logger.debug("Relative template '{}' found relative to {} class: '{}'", new Object[]{template, this.resourceClass.getSimpleName(), path});
            path = PathUtils.leadingSlash((String)classRelativePath);
        }
        if (!path.startsWith("/")) {
            path = PathUtils.path((String[])new String[]{this.restSubContext, path});
            path = PathUtils.leadingSlash((String)ResourceLookup.lookupOrFail(path, this.assets));
            this.logger.debug("Relative template '{}' resolved to '{}'", (Object)template, (Object)path);
        }
        ResourceLookup.existsOrFail(path, this.assets);
        return path;
    }

    public URL loadAsset(String path) {
        return this.assets.load(path);
    }

    public boolean redirectError(Throwable ex) {
        if (this.manualErrorHandling) {
            this.logger.debug("Automatic error handling disabled on path: exception assumed to be handled manually");
        }
        return !this.manualErrorHandling && this.errorRedirect.redirect(this.getRequest(), this.getResponse(), this.wrap(ex));
    }

    private WebApplicationException wrap(Throwable exception) {
        Throwable cause = exception;
        while (cause instanceof MappableException) {
            cause = cause.getCause();
        }
        return cause instanceof WebApplicationException ? (WebApplicationException)cause : new WebApplicationException(cause, 500);
    }
}

