/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.guicey.spa;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import io.dropwizard.Bundle;
import io.dropwizard.servlets.assets.AssetServlet;
import io.dropwizard.setup.Bootstrap;
import io.dropwizard.setup.Environment;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import javax.servlet.DispatcherType;
import javax.servlet.Filter;
import javax.servlet.Servlet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.vyarus.dropwizard.guice.module.installer.bundle.GuiceyBootstrap;
import ru.vyarus.guicey.spa.filter.SpaRoutingFilter;

public class SpaBundle
implements Bundle {
    public static final String SLASH = "/";
    public static final String DEFAULT_PATTERN = "\\.(html|css|js|png|jpg|jpeg|gif|ico|xml|rss|txt|eot|svg|ttf|woff|woff2|cur)(\\?((r|v|rel|rev)=[\\-\\.\\w]*)?)?$";
    private static final ThreadLocal<List<String>> USED_NAMES = new ThreadLocal();
    private final Logger logger = LoggerFactory.getLogger(SpaBundle.class);
    private boolean mainContext;
    private String assetName;
    private String resourcePath;
    private String uriPath;
    private String indexFile = "index.html";
    private String noRedirectRegex = "\\.(html|css|js|png|jpg|jpeg|gif|ico|xml|rss|txt|eot|svg|ttf|woff|woff2|cur)(\\?((r|v|rel|rev)=[\\-\\.\\w]*)?)?$";

    public void initialize(Bootstrap<?> bootstrap) {
        USED_NAMES.remove();
    }

    public void run(Environment environment) {
        List<String> used = USED_NAMES.get();
        if (used == null) {
            used = new ArrayList<String>();
            USED_NAMES.set(used);
        }
        Preconditions.checkArgument((!used.contains(this.assetName) ? 1 : 0) != 0, (String)"SPA with name '%s' is already registered", (Object)this.assetName);
        used.add(this.assetName);
        this.init(environment);
    }

    private void init(Environment environment) {
        Object context = this.mainContext ? environment.servlets() : environment.admin();
        Set clash = context.addServlet(this.assetName, (Servlet)new AssetServlet(this.resourcePath, this.uriPath, this.indexFile, StandardCharsets.UTF_8)).addMapping(new String[]{this.uriPath + '*'});
        if (clash != null && !clash.isEmpty()) {
            throw new IllegalStateException(String.format("Assets servlet %s registration clash with already installed servlets on paths: %s", this.assetName, Joiner.on((char)',').join((Iterable)clash)));
        }
        EnumSet<DispatcherType> types = EnumSet.of(DispatcherType.REQUEST);
        context.addFilter(this.assetName + "Routing", (Filter)new SpaRoutingFilter(this.uriPath, this.noRedirectRegex)).addMappingForServletNames(types, false, new String[]{this.assetName});
        this.logger.info("SPA '{}' for source '{}' registered on uri '{}' in {} context", new Object[]{this.assetName, this.resourcePath, this.uriPath + '*', this.mainContext ? "main" : "admin"});
    }

    public static Builder app(String name, String resourcePath, String uriPath) {
        return new Builder(true, name, resourcePath, uriPath);
    }

    public static Builder adminApp(String name, String resourcePath, String uriPath) {
        return new Builder(false, name, resourcePath, uriPath);
    }

    public static class Builder {
        private final SpaBundle bundle = new SpaBundle();

        public Builder(boolean mainContext, String name, String path, String uri) {
            this.bundle.mainContext = mainContext;
            this.bundle.assetName = (String)Preconditions.checkNotNull((Object)name, (Object)"Name is required");
            this.bundle.uriPath = uri.endsWith(SpaBundle.SLASH) ? uri : uri + SpaBundle.SLASH;
            Preconditions.checkArgument((boolean)path.startsWith(SpaBundle.SLASH), (String)"%s is not an absolute path", (Object)path);
            Preconditions.checkArgument((!SpaBundle.SLASH.equals(path) ? 1 : 0) != 0, (String)"%s is the classpath root", (Object)path);
            this.bundle.resourcePath = path.endsWith(SpaBundle.SLASH) ? path : path + SpaBundle.SLASH;
        }

        public Builder indexPage(String name) {
            this.bundle.indexFile = name;
            return this;
        }

        public Builder preventRedirectRegex(String regex) {
            this.bundle.noRedirectRegex = (String)Preconditions.checkNotNull((Object)regex, (Object)"Regex can't be null");
            return this;
        }

        public SpaBundle build() {
            return this.bundle;
        }

        public void register(GuiceyBootstrap bootstrap) {
            this.bundle.initialize(null);
            this.bundle.run(bootstrap.environment());
        }
    }
}

