/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.guicey.spa.filter;

import com.google.common.base.Strings;
import java.io.IOException;
import java.util.regex.Pattern;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.core.MediaType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.vyarus.guicey.spa.filter.ResponseWrapper;

public class SpaRoutingFilter
implements Filter {
    public static final String SLASH = "/";
    private final Logger logger = LoggerFactory.getLogger(SpaRoutingFilter.class);
    private final String target;
    private final Pattern noRedirect;

    public SpaRoutingFilter(String target, String noRedirectRegex) {
        this.target = target;
        this.noRedirect = Pattern.compile(noRedirectRegex);
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest req = (HttpServletRequest)servletRequest;
        HttpServletResponse resp = (HttpServletResponse)servletResponse;
        if (this.isRoot(req)) {
            this.directCall(req, resp, chain);
        } else {
            this.checkRedirect(req, resp, chain);
        }
    }

    public void destroy() {
    }

    private void directCall(HttpServletRequest req, HttpServletResponse resp, FilterChain chain) throws IOException, ServletException {
        this.noCache(resp);
        chain.doFilter((ServletRequest)req, (ServletResponse)resp);
    }

    private void checkRedirect(HttpServletRequest req, HttpServletResponse resp, FilterChain chain) throws IOException, ServletException {
        ResponseWrapper wrapper = new ResponseWrapper(resp);
        chain.doFilter((ServletRequest)req, (ServletResponse)wrapper);
        int error = wrapper.getError();
        if (error != 404) {
            if (error != 0) {
                resp.sendError(error);
            }
            return;
        }
        if (this.isRedirectAllowed(req)) {
            this.noCache(resp);
            req.getRequestDispatcher(this.target).forward((ServletRequest)req, (ServletResponse)resp);
        } else {
            resp.sendError(error);
        }
    }

    private boolean isRoot(HttpServletRequest req) {
        String uri = req.getRequestURI();
        String path = uri.endsWith(SLASH) ? uri : uri + SLASH;
        return path.equals(this.target);
    }

    private void noCache(HttpServletResponse resp) {
        resp.setHeader("Cache-Control", "must-revalidate,no-cache,no-store");
    }

    private boolean isRedirectAllowed(HttpServletRequest req) {
        String accept = req.getHeader("Accept");
        if (Strings.emptyToNull((String)accept) == null) {
            return false;
        }
        boolean compatible = false;
        for (String type : accept.split(",")) {
            try {
                if (!MediaType.valueOf((String)type).isCompatible(MediaType.TEXT_HTML_TYPE)) continue;
                compatible = true;
                break;
            }
            catch (Exception ex) {
                this.logger.debug("Failed to parse media type '{}':", (Object)type, (Object)ex.getMessage());
            }
        }
        return compatible && !this.noRedirect.matcher(req.getRequestURI()).find();
    }
}

