/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.guicey.spa.filter;

import java.io.IOException;
import java.util.regex.Pattern;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import ru.vyarus.guicey.spa.filter.SpaUtils;

public class SpaRoutingFilter
implements Filter {
    private final String target;
    private final Pattern noRedirect;

    public SpaRoutingFilter(String target, String noRedirectRegex) {
        this.target = target;
        this.noRedirect = Pattern.compile(noRedirectRegex);
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest req = (HttpServletRequest)servletRequest;
        HttpServletResponse resp = (HttpServletResponse)servletResponse;
        if (SpaUtils.isRootPage(req.getRequestURI(), this.target)) {
            SpaUtils.noCache(resp);
            chain.doFilter((ServletRequest)req, (ServletResponse)resp);
        } else {
            this.checkRedirect(req, resp, chain);
        }
    }

    public void destroy() {
    }

    private void checkRedirect(HttpServletRequest req, HttpServletResponse resp, FilterChain chain) throws IOException, ServletException {
        chain.doFilter((ServletRequest)req, (ServletResponse)resp);
        int error = resp.getStatus();
        if (error != 404) {
            return;
        }
        if (SpaUtils.isSpaRoute(req, this.noRedirect)) {
            SpaUtils.doRedirect(req, resp, this.target);
        }
    }
}

