/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.guicey.spa;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import io.dropwizard.core.setup.Environment;
import io.dropwizard.servlets.assets.AssetServlet;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import javax.servlet.DispatcherType;
import javax.servlet.Filter;
import javax.servlet.Servlet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.vyarus.dropwizard.guice.module.installer.bundle.GuiceyBootstrap;
import ru.vyarus.dropwizard.guice.module.installer.bundle.GuiceyBundle;
import ru.vyarus.dropwizard.guice.module.installer.bundle.GuiceyEnvironment;
import ru.vyarus.dropwizard.guice.module.installer.util.PathUtils;
import ru.vyarus.guicey.spa.filter.SpaRoutingFilter;

public class SpaBundle
implements GuiceyBundle {
    public static final String DEFAULT_PATTERN = "\\.(html|css|js|png|jpg|jpeg|gif|ico|xml|rss|txt|eot|svg|ttf|woff|woff2|cur)(\\?((r|v|rel|rev)=[\\-\\.\\w]*)?)?$";
    private final Logger logger = LoggerFactory.getLogger(SpaBundle.class);
    private boolean mainContext;
    private String assetName;
    private String resourcePath;
    private String uriPath;
    private String indexFile = "index.html";
    private String noRedirectRegex = "\\.(html|css|js|png|jpg|jpeg|gif|ico|xml|rss|txt|eot|svg|ttf|woff|woff2|cur)(\\?((r|v|rel|rev)=[\\-\\.\\w]*)?)?$";

    public void initialize(GuiceyBootstrap bootstrap) {
        List used = (List)bootstrap.sharedState(SpaBundle.class, ArrayList::new);
        Preconditions.checkArgument((!used.contains(this.assetName) ? 1 : 0) != 0, (String)"SPA with name '%s' is already registered", (Object)this.assetName);
        used.add(this.assetName);
    }

    public void run(GuiceyEnvironment environment) {
        Environment env = environment.environment();
        Object context = this.mainContext ? env.servlets() : env.admin();
        Set clash = context.addServlet(this.assetName, (Servlet)new AssetServlet(this.resourcePath, this.uriPath, this.indexFile, StandardCharsets.UTF_8)).addMapping(new String[]{this.uriPath + "*"});
        if (clash != null && !clash.isEmpty()) {
            throw new IllegalStateException(String.format("Assets servlet %s registration clash with already installed servlets on paths: %s", this.assetName, Joiner.on((char)',').join((Iterable)clash)));
        }
        EnumSet<DispatcherType> types = EnumSet.of(DispatcherType.REQUEST);
        context.addFilter(this.assetName + "Routing", (Filter)new SpaRoutingFilter(this.uriPath, this.noRedirectRegex)).addMappingForServletNames(types, false, new String[]{this.assetName});
        this.logger.info("SPA '{}' for source '{}' registered on uri '{}' in {} context", new Object[]{this.assetName, this.resourcePath, this.uriPath + "*", this.mainContext ? "main" : "admin"});
    }

    public static Builder app(String name, String resourcePath, String uriPath) {
        return new Builder(true, name, resourcePath, uriPath);
    }

    public static Builder adminApp(String name, String resourcePath, String uriPath) {
        return new Builder(false, name, resourcePath, uriPath);
    }

    public static class Builder {
        private final SpaBundle bundle = new SpaBundle();

        public Builder(boolean mainContext, String name, String path, String uri) {
            this.bundle.mainContext = mainContext;
            this.bundle.assetName = (String)Preconditions.checkNotNull((Object)name, (Object)"Name is required");
            this.bundle.uriPath = PathUtils.trailingSlash((String)uri);
            this.bundle.resourcePath = PathUtils.normalizeClasspathPath((String)path);
            Preconditions.checkArgument((!"/".equals(this.bundle.resourcePath) ? 1 : 0) != 0, (String)"%s is the classpath root", (Object)path);
        }

        public Builder indexPage(String name) {
            this.bundle.indexFile = name;
            return this;
        }

        public Builder preventRedirectRegex(String regex) {
            this.bundle.noRedirectRegex = (String)Preconditions.checkNotNull((Object)regex, (Object)"Regex can't be null");
            return this;
        }

        public SpaBundle build() {
            return this.bundle;
        }
    }
}

