/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.guicey.spa.filter;

import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.regex.Pattern;
import ru.vyarus.guicey.spa.filter.SpaUtils;

public class SpaRoutingFilter
implements Filter {
    private final String target;
    private final Pattern noRedirect;

    public SpaRoutingFilter(String target, String noRedirectRegex) {
        this.target = target;
        this.noRedirect = Pattern.compile(noRedirectRegex);
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest req = (HttpServletRequest)servletRequest;
        HttpServletResponse resp = (HttpServletResponse)servletResponse;
        if (SpaUtils.isRootPage(req.getRequestURI(), this.target)) {
            SpaUtils.noCache(resp);
            chain.doFilter((ServletRequest)req, (ServletResponse)resp);
        } else {
            this.checkRedirect(req, resp, chain);
        }
    }

    public void destroy() {
    }

    private void checkRedirect(HttpServletRequest req, HttpServletResponse resp, FilterChain chain) throws IOException, ServletException {
        chain.doFilter((ServletRequest)req, (ServletResponse)resp);
        int error = resp.getStatus();
        if (error != 404) {
            return;
        }
        if (SpaUtils.isSpaRoute(req, this.noRedirect)) {
            SpaUtils.doRedirect(req, resp, this.target);
        }
    }
}

