/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.guicey.spa.filter;

import com.google.common.base.Strings;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.ws.rs.core.MediaType;
import java.io.IOException;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.vyarus.dropwizard.guice.module.installer.util.PathUtils;

public final class SpaUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(SpaUtils.class);

    private SpaUtils() {
    }

    public static boolean isRootPage(String currentPath, String rootPath) {
        String path = PathUtils.trailingSlash((String)currentPath);
        return path.equals(rootPath);
    }

    public static boolean isHtmlRequest(HttpServletRequest req) {
        String accept = req.getHeader("Accept");
        if (Strings.emptyToNull((String)accept) != null) {
            for (String type : accept.split(",")) {
                try {
                    if (MediaType.valueOf((String)type).equals((Object)MediaType.TEXT_HTML_TYPE)) {
                        return true;
                    }
                }
                catch (Exception ex) {
                    LOGGER.debug("Failed to parse media type '" + type + "':", (Object)ex.getMessage());
                }
            }
        }
        return false;
    }

    public static boolean isSpaRoute(HttpServletRequest req, Pattern noRedirect) {
        return SpaUtils.isHtmlRequest(req) && !noRedirect.matcher(req.getRequestURI()).find();
    }

    public static void noCache(HttpServletResponse resp) {
        resp.setHeader("Cache-Control", "must-revalidate,no-cache,no-store");
    }

    public static void doRedirect(HttpServletRequest req, HttpServletResponse res, String target) throws IOException, ServletException {
        res.reset();
        SpaUtils.noCache(res);
        req.getRequestDispatcher(target).forward((ServletRequest)req, (ServletResponse)res);
    }
}

