/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.dropwizard.guice.test.spock.ext;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import ru.vyarus.dropwizard.guice.hook.GuiceyConfigurationHook;
import ru.vyarus.dropwizard.guice.test.ClientSupport;
import ru.vyarus.dropwizard.guice.test.EnableHook;
import ru.vyarus.dropwizard.guice.test.spock.InjectClient;
import ru.vyarus.dropwizard.guice.test.util.HooksUtil;
import spock.lang.Shared;

public final class SpecialFieldsSupport {
    private SpecialFieldsSupport() {
    }

    public static List<GuiceyConfigurationHook> findHooks(Class<?> test) {
        ArrayList<GuiceyConfigurationHook> hooks = new ArrayList<GuiceyConfigurationHook>();
        List<Field> fields = SpecialFieldsSupport.findFields(test, field -> field.isAnnotationPresent(EnableHook.class));
        HooksUtil.validateFieldHooks(fields, (boolean)false);
        for (Field field2 : fields) {
            field2.setAccessible(true);
            GuiceyConfigurationHook hook = (GuiceyConfigurationHook)SpecialFieldsSupport.getValue(field2);
            if (hook == null) continue;
            hooks.add(hook);
        }
        return hooks;
    }

    public static List<Field> findClientFields(Class<?> test) {
        List<Field> fields = SpecialFieldsSupport.findFields(test, it -> it.isAnnotationPresent(InjectClient.class));
        for (Field field : fields) {
            if (field.getType().equals(ClientSupport.class)) continue;
            throw new IllegalStateException(String.format("Field %s annotated with @%s, but its type is not %s", SpecialFieldsSupport.toString(field), InjectClient.class.getSimpleName(), ClientSupport.class.getSimpleName()));
        }
        return fields;
    }

    public static void initClients(Object instance, List<Field> fields, ClientSupport client, boolean shared) {
        for (Field field : fields) {
            if (field.isAnnotationPresent(Shared.class) != shared || instance == null && !Modifier.isStatic(field.getModifiers()) || instance != null && Modifier.isStatic(field.getModifiers())) continue;
            field.setAccessible(true);
            try {
                field.set(instance, client);
            }
            catch (Exception e) {
                throw new IllegalStateException("Failed to set value to field " + SpecialFieldsSupport.toString(field), e);
            }
        }
    }

    private static List<Field> findFields(Class<?> src, Predicate<Field> predicate) {
        ArrayList<Field> res = new ArrayList<Field>();
        for (Class<?> cls = src; cls != Object.class && cls != null; cls = cls.getSuperclass()) {
            for (Field fld : cls.getDeclaredFields()) {
                if (!predicate.test(fld)) continue;
                res.add(fld);
            }
        }
        return res;
    }

    private static <T> T getValue(Field field) {
        try {
            return (T)field.get(null);
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to access static field value " + SpecialFieldsSupport.toString(field), e);
        }
    }

    private static String toString(Field field) {
        return field.getDeclaringClass().getName() + "." + field.getName();
    }
}

