/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.dropwizard.guice.test.spock.ext;

import com.google.common.base.Strings;
import io.dropwizard.testing.ConfigOverride;
import io.dropwizard.testing.DropwizardTestSupport;
import ru.vyarus.dropwizard.guice.hook.GuiceyConfigurationHook;
import ru.vyarus.dropwizard.guice.module.installer.util.PathUtils;
import ru.vyarus.dropwizard.guice.test.spock.UseDropwizardApp;
import ru.vyarus.dropwizard.guice.test.spock.ext.AbstractAppExtension;
import ru.vyarus.dropwizard.guice.test.spock.ext.GuiceyInterceptor;
import ru.vyarus.dropwizard.guice.test.util.ConfigOverrideUtils;
import ru.vyarus.dropwizard.guice.test.util.RandomPortsListener;

public class DropwizardAppExtension
extends AbstractAppExtension<UseDropwizardApp> {
    private static final String STAR = "*";

    @Override
    protected GuiceyInterceptor.EnvironmentSupport buildSupport(final UseDropwizardApp annotation, Class<?> test) {
        return new GuiceyInterceptor.AbstractEnvironmentSupport(test){

            @Override
            protected DropwizardTestSupport build() {
                DropwizardTestSupport support = new DropwizardTestSupport(annotation.value(), annotation.config(), DropwizardAppExtension.this.buildConfigOverrides(annotation));
                if (annotation.randomPorts()) {
                    support.addListener((DropwizardTestSupport.ServiceListener)new RandomPortsListener());
                }
                return support;
            }
        };
    }

    @Override
    protected Class<? extends GuiceyConfigurationHook>[] getHooks(UseDropwizardApp annotation) {
        return annotation.hooks();
    }

    private ConfigOverride[] buildConfigOverrides(UseDropwizardApp annotation) {
        ConfigOverride[] overrides = this.convertOverrides(annotation.configOverride());
        if (!Strings.isNullOrEmpty((String)annotation.restMapping())) {
            String mapping = PathUtils.leadingSlash((String)annotation.restMapping());
            if (!mapping.endsWith(STAR)) {
                mapping = PathUtils.trailingSlash((String)mapping) + STAR;
            }
            overrides = ConfigOverrideUtils.merge((ConfigOverride[])overrides, (ConfigOverride[])new ConfigOverride[]{ConfigOverride.config((String)"server.rootPath", (String)mapping)});
        }
        return overrides;
    }
}

