/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.dropwizard.guice.test.spock.ext;

import io.dropwizard.Application;
import io.dropwizard.Configuration;
import io.dropwizard.testing.ConfigOverride;
import io.dropwizard.testing.DropwizardTestSupport;
import ru.vyarus.dropwizard.guice.hook.GuiceyConfigurationHook;
import ru.vyarus.dropwizard.guice.test.TestCommand;
import ru.vyarus.dropwizard.guice.test.spock.UseGuiceyApp;
import ru.vyarus.dropwizard.guice.test.spock.ext.AbstractAppExtension;
import ru.vyarus.dropwizard.guice.test.spock.ext.GuiceyInterceptor;

public class GuiceyAppExtension
extends AbstractAppExtension<UseGuiceyApp> {
    @Override
    protected GuiceyInterceptor.EnvironmentSupport buildSupport(UseGuiceyApp annotation, Class<?> test) {
        return new GuiceyTestEnvironment(annotation, test);
    }

    @Override
    protected Class<? extends GuiceyConfigurationHook>[] getHooks(UseGuiceyApp annotation) {
        return annotation.hooks();
    }

    private class GuiceyTestEnvironment
    extends GuiceyInterceptor.AbstractEnvironmentSupport {
        private final UseGuiceyApp annotation;
        private TestCommand command;

        GuiceyTestEnvironment(UseGuiceyApp annotation, Class<?> test) {
            super(test);
            this.annotation = annotation;
        }

        @Override
        protected DropwizardTestSupport build() {
            return this.create(this.annotation.value(), this.annotation.config(), GuiceyAppExtension.this.convertOverrides(this.annotation.configOverride()));
        }

        @Override
        public void after() {
            super.after();
            if (this.command != null) {
                this.command.stop();
            }
        }

        private <C extends Configuration> DropwizardTestSupport<C> create(Class<? extends Application> app, String configPath, ConfigOverride ... overrides) {
            return new DropwizardTestSupport(app, configPath, (String)null, application -> {
                this.command = new TestCommand(application);
                return this.command;
            }, overrides);
        }
    }
}

